package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈活动基本信息查询对象〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:39
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class DycActivityDO implements Serializable {

    private static final long serialVersionUID = 5716364943750564258L;

    private int pageNo = 1;
    private int pageSize = 10;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 引用活动id
     */
    private Long quoteActivityId;
    /**
     * 活动版本号
     */
    private Integer activityVersion;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动场景id
     */
    private Long activitySceneId;
    /**
     * 活动场景名称
     */
    private String activitySceneName;
    /**
     * 活动PC端banner图url
     */
    private String pcBannerPicUrl;
    /**
     * 活动浮窗图url
     */
    private String emergePicUrl;
    /**
     * 活动app端banner图url
     */
    private String appBannerPicUrl;
    /**
     * 活动同步状态:
     * 1:待同步
     * 2：同步中
     * 3：同步成功
     * 4：同步失败
     */
    private Integer activitySyncState;
    /**
     * 发放范围：1：全部用户；2：未发放积分用户
     */
    private String issueRange;
    /**
     * 用户总数
     */
    private Integer totalUser;
    /**
     * 积分总数
     */
    private BigDecimal totalScores;
    /**
     * 商品总数
     */
    private Integer totalCommodity;
    /**
     * 类目总数
     */
    private Integer totalCatalog;
    /**
     * 是否结算:
     * 0:未结算；
     * 1：已结算
     */
    private Integer isSettleFlag;
    /**
     * 剩余积分最小值
     */
    private BigDecimal balanceScoresMin;
    /**
     * 剩余积分最大值
     */
    private BigDecimal balanceScoresMax;
    /**
     * 活动开始时间
     */
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    private Date activityEndTime;
    /**
     * 创建开始时间
     */
    private Date createStartTime;
    /**
     * 创建结束时间
     */
    private Date createEndTime;
    /**
     * 页签id：
     * 1001：待生效
     * 1002：生效中
     * 1003：已失效
     * 1004：全部
     */
    private String tabId;
    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动类型:1:工会活动；2：劳防活动
     */
    private Integer activityType;
    /**
     * 活动期限:1:有限期，2:无限期
     */
    private Integer activityCycleType;
    /**
     * 支付方式:1:积分支付；2：混合支付
     */
    private Integer activityPayMode;
    /**
     * 活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    private String activityState;
    /**
     * 删除标志
     * 0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 商品关联方式:1:商品池；2：商品类型；3：商品
     */
    private Integer commodityRelaMethod;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
    /**
     * 创建人机构ID
     */
    private Long createOrgId;
    /**
     * 创建人机构名称
     */
    private String createOrgName;
    /**
     * 创建人机构路径
     */
    private String createOrgTreePath;
    /**
     * 创建人公司ID
     */
    private Long createCompanyId;
    /**
     * 创建人公司名称
     */
    private String createCompanyName;
    /**
     * 商品类型ID
     */
    private Long commodityTypeId;
    /**
     * 商品类型名称
     */
    private String commodityTypeName;
    /**
     * 单品ID
     */
    private Long skuId;
    /**
     * 单品编码
     */
    private String skuCode;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 单品名称
     */
    private Integer skuStatus;
    /**
     * 用户id
     */
    private Long actUserId;
    /**
     * 用户名
     */
    private String actUserName;
    /**
     * 用户姓名
     */
    private String actName;
    /**
     * 电话
     */
    private String phone;
    /**
     * 工号
     */
    private String actWorkNo;
    /**
     * 积分状态（0：正常，1：冻结）
     */
    private Integer scoresType;
    /**
     * 发放积分（第一次的发放）
     */
    private BigDecimal giveScores;
    /**
     * 已使用积分
     */
    private BigDecimal usedScores;
    /**
     * 剩余可用积分
     */
    private BigDecimal balanceScores;
    /**
     * 用户所属组织ID
     */
    private Long actUserOrgId;
    /**
     * 用户所属组织名称
     */
    private String actUserOrgName;
    /**
     * 业务对象ID
     */
    private Long objId;
    /**
     * 业务对象类型:
     * 1：活动
     * 2：活动变更单
     * 3：审批单
     */
    private Integer objType;
    /**
     * 供应商id集合
     */
    private List<Long> supplierIds;
    /**
     * 商品池id列表
     */
    private List<Long> commodityPoolIdList;
    /**
     * 商品类型Id列表
     */
    private List<Long> relaIdList;
    /**
     * 商品id列表
     */
    private List<Long> skuIdList;
    /**
     * 商品池列表列表
     */
    private List<DycActivityCommodityPoolInfo> activityCommodityPoolInfos;
    /**
     * 商品类型列表
     */
    private List<DycActiveCommodityCatalogInfo> commodityCatalogInfoBOS;
    /**
     * 商品列表
     */
    private List<DycActActivityRelaCommodityInfo> actActivityRelaCommodityBOS;
    /**
     * 活动用户列表
     */
    private List<DycActivityUserInfo> activityUserList;
    /**
     * 用户id列表
     */
    private List<Long> userIdList;
    /**
     * 单据编号
     */
    private String objCode;
    /**
     * 使用人名称
     */
    private String useUserName;
    /**
     * 使用人Id
     */
    private Long useUserId;
    /**
     * 使用开始时间
     */
    private Date useStartTime;
    /**
     * 使用结束时间
     */
    private Date useEndTime;
    /**
     * 操作类型：2：消费:3：退回
     */
    private String operType;
    /**
     * 使用/退回积分
     */
    private BigDecimal useScores;
    /**
     * 使用时间
     */
    private Date useTime;
    /**
     * 好评率
     */
    private String favorableRate;
    /**
     * 最小价格
     */
    private BigDecimal minPrice;
    /**
     * 最大价格
     */
    private BigDecimal maxPrice;
    /**
     * 最后付款日期
     */
    private Date lastPayTime;
    /**
     * 最后付款日期
     */
    private Date lastPayTimeStart;
    /**
     * 最后付款日期
     */
    private Date lastPayTimeEnd;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTime;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTimeStart;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTimeEnd;


    /**
     * 一级类目id
     */
    private String firstCatalogId;
    /**
     * 二级类目id
     */
    private String secondCatalogId;
    /**
     * 三级类目id
     */
    private String threeCatalogId;
    /**
     * 商品池名称，多个商品池用逗号分隔
     */
    private String commodityPoolName;
    /**
     * 品牌
     */
    private String brand;
    /**
     * 好评率排序：ASC：升序，DESC：降序。默认为降序
     */
    private String favorableRateOrder = "DESC";
    /**
     * 外部的活动id
     */
    private String extActivityId;
    /**
     * 活动场景名称
     */
    private String activitySceneCode;
    /**
     * 发票ID
     */
    private Long invoiceId;
    /**
     * 发票抬头
     */
    private String invoiceTitle;
    /**
     * 发票类别;1:纸质发票 2:电子发票
     */
    private Integer invoiceClass;
    /**
     * 发票类型:1:专用发票；2：普通发票
     */
    private Integer invoiceType;
    /**
     * 发票纳税人识别号
     */
    private String invoiceTaxpayerId;
    /**
     * 发票开户银行
     */
    private String invoiceBank;
    /**
     * 发票开户银行账户
     */
    private String invoiceBankAccount;
    /**
     * 发票地址
     */
    private String invoiceAddress;
    /**
     * 发票电话
     */
    private String invoicePhone;
    /**
     * 发票地址Id
     */
    private Long invoiceAddrId;
    /**
     * 发票地址省编码
     */
    private String provinceId;
    /**
     * 发票地址省名称
     */
    private String provinceName;
    /**
     * 发票地址地市名称
     */
    private String cityName;
    /**
     * 发票地址地市编号
     */
    private String cityId;
    /**
     * 发票地址乡镇编号
     */
    private String townName;
    /**
     * 发票地址乡镇名称
     */
    private String townId;
    /**
     * 发票地址区县名称
     */
    private String countyName;
    /**
     * 发票地址区县编号
     */
    private String countyId;
    /**
     * 发票地址联系人
     */
    private String contactName;
    /**
     * 发票地址联系人电话
     */
    private String contactPhone;
    /**
     * 发票地址联系人邮箱
     */
    private String contactEmial;
    /**
     * 活动备注
     */
    private String remark;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新开始时间
     */
    private Date updateTimeStart;
    /**
     * 更新结束时间
     */
    private Date updateTimeEnd;
    /**
     * 等于1就查询
     */
    private Integer flagQry;
    /**
     * 同步类型 1：活动同步 2：活动变更同步
     */
    private Integer operTypeSync;
    /**
     * 是否查询供应商信息：等于1就查询
     */
    private Integer supplierFlag;
    /**
     * 等于1 就走另一种查询
     */
    private Integer quoteActivity;
    /**
     * 积分数
     */
    private BigDecimal scores;
}
