package com.tydic.dyc.act.model.bo;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: ActivityFlowInstanceBO
 * @Description: ActivityFlowInstanceBO
 * @author: zhoulu
 * @date: 2023年12月19日15:49:50
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class DycActivityFlowInstanceInfo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * ID
	 */
    private Long id;
	/**
	 * 单据id
	 */
    private Long objId;
	/**
	 * 单据类型:
            1:活动
            2：活动变更
	 */
    private Integer objType;
	/**
	 * 流程类型：
            1：活动审批
            2：活动变更审批
	 */
    private Integer flowType;
	/**
	 * 流程key
	 */
    private String flowKey;
	/**
	 * 流程定义id
	 */
    private String flowDefId;
	/**
	 * 流程实例id
	 */
    private String flowInstId;
	/**
	 * 当前节点编码
	 */
    private String currentNodeCode;
	/**
	 * 当前节点名称
	 */
    private String currentNodeName;
	/**
	 * 当前节点状态1审批中2已审批
	 */
    private Integer currentNodeStatus;
	/**
	 * 审批发起时间
	 */
    private Date auditStartTime;
	/**
	 * 审批结束时间
	 */
    private Date auditEndTime;
	/**
	 * 流程结束原因
	 */
    private String auditEndReason;
	/**
	 * 审批流是否结束：0:结束；1：未结束
	 */
    private Integer isFinish;
	/**
	 * 审批发起人id
	 */
    private Long auditCreateUserId;
	/**
	 * 审批发起人名称
	 */
    private String auditCreateUserName;
	/**
	 * 审批发起人机构id
	 */
    private Long auditCreateOrgId;
	/**
	 * 审批发起人机构名称
	 */
    private String auditCreateOrgName;
	/**
	 * 审批发起人机构树路径
	 */
	private String auditCreateOrgPath;
	/**
	 * 审批发起人公司id
	 */
    private Long auditCreateCompanyId;
	/**
	 * 审批发起人公司名称
	 */
    private String auditCreateCompanyName;
	/**
	 * 删除标志（0代表存在 1代表删除）
	 */
    private Integer delFlag;

}