package com.tydic.dyc.act.model.bo;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: ActivityFlowTaskBO
 * @Description: ActivityFlowTaskBO
 * @author: zhoulu
 * @date: 2023年12月19日15:49:50
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class DycActivityFlowTaskInfo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * ID
	 */
    private Long id;
	/**
	 * 任务id
	 */
    private String taskId;
	/**
	 * 流程实例id
	 */
    private String flowInstId;
	/**
	 * 当前节点编码
	 */
    private String currentNodeCode;
	/**
	 * 当前节点名称
	 */
    private String currentNodeName;
	/**
	 * 待审批人id
	 */
    private Long pendingAuditUserId;
	/**
	 * 待审批人名称
	 */
    private String pendingAuditUserName;
	/**
	 * 待审批人机构id
	 */
    private Long pendingAuditOrgId;
	/**
	 * 待审批人机构名称
	 */
    private String pendingAuditOrgName;
	/**
	 * 待审批人公司id
	 */
    private Long pendingAuditCompanyId;
	/**
	 * 待审批人公司名称
	 */
    private String pendingAuditCompanyName;
	/**
	 * 任务状态1待审核2已通过3已驳回4已取消
	 */
    private Integer taskStatus;
	/**
	 * 审批人id
	 */
    private Long auditUserId;
	/**
	 * 审批人名称
	 */
    private String auditUserName;
	/**
	 * 审批人机构id
	 */
    private Long auditOrgId;
	/**
	 * 审批人机构名称
	 */
    private String auditOrgName;
	/**
	 * 审批人公司id
	 */
    private Long auditCompanyId;
	/**
	 * 审批人公司名称
	 */
    private String auditCompanyName;
	/**
	 * 审批时间
	 */
    private Date auditTime;
	/**
	 * 任务创建时间
	 */
    private Date taskCreateTime;
	/**
	 * 驳回原因
	 */
    private String rejectReason;
	/**
	 * 删除标志（0代表存在 1代表删除）
	 */
    private Integer delFlag;
	/**
	 * 更新者id
	 */
    private Long updateUserId;
	/**
	 * 更新者名称
	 */
    private String updateUserName;
	/**
	 * 更新时间
	 */
    private Date updateTime;

}