package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 说明：
 *
 * @author zhoulu
 * @date 2023年12月18日 16:28
 */
@Data
public class DycActivityUserInfo implements Serializable {
    private static final long serialVersionUID = -1501411246274186416L;

    /**
     * ID
     */
    private Long id;

    /**
     * ID
     */
    private List<Long> ids;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 用户id
     */
    private Long actUserId;
    /**
     * 用户名
     */
    private String actUserName;
    /**
     * 用户姓名
     */
    private String actName;
    /**
     * 工号
     */
    private String actWorkNo;
    /**
     * 性别; 1 男 2 女
     */
    private Integer sex;
    /**
     * 电话
     */
    private String phone;
    /**
     * 用户所属组织ID
     */
    private Long actUserOrgId;
    /**
     * 用户所属组织名称
     */
    private String actUserOrgName;
    /**
     * 用户所属公司ID
     */
    private Long actUserCompanyId;
    /**
     * 用户所属公司名称
     */
    private String actUserCompanyName;
    /**
     * 用户所属机构树路径
     */
    private String actUserOrgPath;
    /**
     * 积分状态（0：正常，1：冻结）
     */
    private Integer scoresType;
    /**
     * 发放积分（第一次的发放）
     */
    private BigDecimal giveScores;
    /**
     * 已使用积分
     */
    private BigDecimal usedScores;
    /**
     * 剩余可用积分
     */
    private BigDecimal balanceScores;
    /**
     * 删除标志
     0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
    /**
     * 排序
     */
    private String orderBy;

    /**
     * 是否已经发送预警通知：1：发送 0或空:未发送
     */
    private Integer isNotify;
    /**
     * 变更单ID
     */
    private Long changeId;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 用户姓名
     */
    private String name;
    /**
     * 工号
     */
    private String workNo;
    /**
     * 用户所属组织ID
     */
    private Long userOrgId;
    /**
     * 用户所属组织名称
     */
    private String userOrgName;

    /**
     * 用户所属公司ID
     */
    private Long userCompanyId;
    /**
     * 用户所属公司名称
     */
    private String userCompanyName;
    /**
     * 用户所属机构树路径
     */
    private String userOrgPath;
    /**
     * 变更前积分
     */
    private BigDecimal originalScores;
    /**
     * 	用户id列表
     */
    private List<Long> userIdList;
    /**
     * 限制积分
     */
    private BigDecimal limitScores;
    /**
     * 创建时间
     */
    private Date createTimeEnd;
    /**
     * 创建时间
     */
    private Date createTimeStart;
    /**
     * 更新时间
     */
    private Date updateTimeStart;
    /**
     * 更新时间
     */
    private Date updateTimeEnd;

}
