package com.tydic.dyc.act.model.bo;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description: FromChildren
 * @Author: the_xhl 从children开始构建 实现类
 * @Date: 2022-12-08
 */
@Slf4j
public class FromChildren implements BuildTree {


	@Override
	public void buildTree(DycActQueryCatalogListBO uccGuideCatalogBO, List<DycActQueryCatalogListBO> catalogDealList, List<DycActQueryCatalogListBO> result, Map<Long, List<DycActQueryCatalogListBO>> pIdGroupMap) {
		// 父层级
		DycActQueryCatalogListBO parent = catalogDealList.stream().filter(e -> e.getGuideCatalogId().equals(uccGuideCatalogBO.getUpperCatalogId())).findAny().orElse(null);

		// 如果为空，说明已经是最顶级节点，装入结果集合返回
		if (ObjectUtil.isNull(parent)) {
		    // 如果当前结果集里已经有该一级类目，就不用加入结果集了，防止重复
            List<DycActQueryCatalogListBO> collect = result.stream().filter(e -> e.getGuideCatalogId().equals(uccGuideCatalogBO.getGuideCatalogId())).collect(Collectors.toList());
            if (collect.isEmpty()) {
                result.add(uccGuideCatalogBO);
            }
            return;
		}
		// 设置子层级
		// 取出含有相同父节点的节点
		List<DycActQueryCatalogListBO> currentList = pIdGroupMap.get(uccGuideCatalogBO.getUpperCatalogId());
		if (CollectionUtil.isEmpty(currentList)) {
			currentList = new ArrayList<>();
		}
		// 删除
		currentList.forEach(e -> e.setFlag(true));
		//判断类目是否已在集合中
		List<Long> catalogIds = currentList.stream().map(a -> a.getGuideCatalogId()).collect(Collectors.toList());
		if(!catalogIds.contains(uccGuideCatalogBO.getGuideCatalogId())){
			currentList.add(uccGuideCatalogBO);
		}
		List<DycActQueryCatalogListBO> childList = currentList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(DycActQueryCatalogListBO::getGuideCatalogId))), ArrayList::new));
		List<DycActQueryCatalogListBO> childs = parent.getChilds();

		if (CollectionUtil.isEmpty(childs)) {
			childs = new ArrayList<>();
		}

		//判断子集是否已经添加
		if(!CollectionUtils.isEmpty(childs)){
			if(childs.containsAll(childList)){
				log.info("重复类目数据："+childList);
			}else {
				// 将 list1 中的 id 转换为 Set
				Set<Long> idSet = childs.stream()
						.map(DycActQueryCatalogListBO::getGuideCatalogId)
						.collect(Collectors.toSet());

				// 从 list2 中筛选出与 list1 中 id 不相同的元素，并添加到 list1 中
				List<DycActQueryCatalogListBO> intersection = childList.stream()
						.filter(bo -> !idSet.contains(bo.getGuideCatalogId()))
						.collect(Collectors.toList());

				childs.addAll(intersection);
				//childs.addAll(childList);
			}
		}else {
			childs.addAll(childList);
		}
		childs = childs.stream().sorted(Comparator.comparing(DycActQueryCatalogListBO::getViewOrder)).collect(Collectors.toList());
		parent.setChilds(childs);

		buildTree(parent, catalogDealList, result, pIdGroupMap);
	}
}
