package com.tydic.dyc.act.model.bo;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListBO;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Description: FromRoot
 * @Author: the_xhl 从root开始构建 实现类
 * @Date: 2022-12-08
 */
public class FromRoot implements BuildTree {


	@Override
	public void buildTree(DycActQueryCatalogListBO uccGuideCatalogBO, List<DycActQueryCatalogListBO> catalogDealList, List<DycActQueryCatalogListBO> result, Map<Long, List<DycActQueryCatalogListBO>> pIdGroupMap) {
		// 子节点
		List<DycActQueryCatalogListBO> childrenList = catalogDealList.stream().filter(e -> e.getUpperCatalogId().equals(uccGuideCatalogBO.getGuideCatalogId())).collect(Collectors.toList());

		// 如果为空，说明已经是最顶级节点，装入结果集合返回
		if (CollectionUtil.isEmpty(childrenList)) {
			return;
		}

		catalogDealList.removeAll(childrenList);

		List<DycActQueryCatalogListBO> childList = childrenList.stream().sorted(Comparator.comparing(DycActQueryCatalogListBO::getViewOrder)).collect(Collectors.toList());

		uccGuideCatalogBO.setChilds(childList);

		childrenList.forEach(e -> buildTree(e, catalogDealList, result, pIdGroupMap));
	}
}
