package com.tydic.dyc.act.model.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.model.api.ActSysDictionaryModel;
import com.tydic.dyc.act.model.bo.ActSysDictionaryBO;
import com.tydic.dyc.act.model.bo.ActSysDictionaryQryBO;
import com.tydic.dyc.act.repository.api.ActSysDictionaryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题 ActSysDictionaryModelImpl
 * 说明
 * 时间 2024/4/11 14:58
 *
 * @author 唐富强
 */
@Service
public class ActSysDictionaryModelImpl implements ActSysDictionaryModel {

    @Autowired
    private ActSysDictionaryRepository actSysDictionaryRepository;

    /**
     * 字典翻译
     * @param pCodes
     * @return
     */
    @Override
    public Map<String, Map<String, String>> getDictionaryMap(List<String> pCodes) {
        ActSysDictionaryQryBO actSysDictionaryQryBO = new ActSysDictionaryQryBO();
        actSysDictionaryQryBO.setPCodes(pCodes);
        List<ActSysDictionaryBO> sysDictionaryBOList = actSysDictionaryRepository.getList(actSysDictionaryQryBO);
        Map<String, Map<String, String>> dicPCodeAndCodeMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(sysDictionaryBOList)) {
            //根据pCode和code分组
            Map<String, List<ActSysDictionaryBO>> dicPCodeMap =
                    sysDictionaryBOList.stream().collect(Collectors.groupingBy(ActSysDictionaryBO::getPCode));
            Iterator<String> iterator = dicPCodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String pCode = iterator.next();
                Map<String, String> dicCodeMap =
                        dicPCodeMap.get(pCode).stream().collect(Collectors.toMap(ActSysDictionaryBO::getCode, ActSysDictionaryBO::getDescrip, (k1, k2) -> k2));
                dicPCodeAndCodeMap.put(pCode, dicCodeMap);
            }
        }
        return dicPCodeAndCodeMap;
    }
}
