package com.tydic.dyc.act.model.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.*;
import com.tydic.dyc.act.service.bo.DycActActivitySupplierInfoBO;
import com.tydic.dyc.act.service.bo.DycActActivityUserInfoBO;
import com.tydic.dyc.act.service.bo.DycActCheckUserNotScoreReqBo;
import com.tydic.dyc.act.service.bo.DycActCheckUserNotScoreRspBo;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 描述: 〈活动子域相关方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:14
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Slf4j
@Service
public class DycActActivityModelImpl implements DycActActivityModel {


    @Autowired
    private DycActActivityRepository dycActActivityRepository;

    @Autowired
    private DycActFileRepository dycActFileRepository;

    @Autowired
    private DycActActivitySupplierRepository dycActActivitySupplierRepository;

    @Autowired
    private DycActActivityCommodityRepository dycActActivityCommodityRepository;

    @Autowired
    private DycActActivityUserRepository dycActActivityUserRepository;

    @Autowired
    private DycActConfigRepository dycActConfigRepository;

    @Autowired
    private DycActSkuInfoRepository dycActSkuInfoRepository;
    @Autowired
    private DycActActivitySyncExternalRecordRepository dycActActivitySyncExternalRecordRepository;
    @Autowired
    private DycActOrderInfoRepository dycActOrderInfoRepository;
    @Autowired
    private DycActActivityChangeRepository dycActActivityChangeRepository;

    /**
     * 根据条件查询活动基本信息列表（分页）
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        BasePageRspBo<DycActivityBaseInfo> rspBo = dycActActivityRepository.queryActivityPageList(reqBO);
        //返回是否有订单记录、积分记录、变更记录
        if (!CollectionUtils.isEmpty(rspBo.getRows()) && null != reqBO.getFlagQry()) {
            List<Long> actId = new ArrayList<>();
            List<String> actCode = new ArrayList<>();

            rspBo.getRows().forEach(item -> {
                actId.add(item.getActivityId());
                actCode.add(item.getActivityCode());
            });
            Map<Long, DycActOrderInfo> actOrderInfoMap = new HashMap<>();
            Map<String, DycActivityChangeInfo> changeInfoMap = new HashMap<>();
            List<DycActOrderInfo> orderInfos = dycActOrderInfoRepository.qryActSum(actId);
            List<DycActivityChangeInfo> changeInfos = dycActActivityChangeRepository.qrySum(actCode);
            if (!CollectionUtils.isEmpty(orderInfos)) {
                actOrderInfoMap = orderInfos.stream().collect(Collectors.toMap(DycActOrderInfo::getActivityId, item -> item));
                Map<Long, DycActOrderInfo> finalActOrderInfoMap = actOrderInfoMap;
                rspBo.getRows().forEach(item -> {
                    if (finalActOrderInfoMap.containsKey(item.getActivityId()) && finalActOrderInfoMap.get(item.getActivityId()).getTotal() > 0) {
                        item.setOrderFalg(true);
                        item.setScores(true);
                    }
                });
            }
            if (!CollectionUtils.isEmpty(changeInfos)) {
                changeInfoMap = changeInfos.stream().collect(Collectors.toMap(DycActivityChangeInfo::getOriginalActivityCode, item -> item));
                Map<String, DycActivityChangeInfo> finalChangeInfoMap = changeInfoMap;
                rspBo.getRows().forEach(item -> {
                    if (finalChangeInfoMap.containsKey(item.getActivityCode()) && finalChangeInfoMap.get(item.getActivityCode()).getTotal() > 0) {
                        item.setChangeFalg(true);
                    }
                });
            }
        }
        //查询供应商信息，只在结算列表使用
        if (!CollectionUtils.isEmpty(rspBo.getRows()) && null != reqBO.getSupplierFlag()) {
            List<Long> actId = new ArrayList<>();
            rspBo.getRows().forEach(item -> {
                actId.add(item.getActivityId());
            });
            DycActivitySupplierInfo supplierInfo = new DycActivitySupplierInfo();
            supplierInfo.setActivityIds(actId);
            List<DycActivitySupplierInfo> infoList = dycActActivitySupplierRepository.batchQrySupplier(supplierInfo);
            if (!CollectionUtils.isEmpty(infoList)) {
                Map<Long, List<DycActivitySupplierInfo>> collect = infoList.stream().collect(Collectors.groupingBy(DycActivitySupplierInfo::getActivityId));
                rspBo.getRows().forEach(item -> {
                    List<DycActivitySupplierInfo> supplierInfos = collect.get(item.getActivityId());
                    if (!CollectionUtils.isEmpty(supplierInfos)) {
                        item.setActivitySupplierList(JSON.parseArray(JSON.toJSONString(supplierInfos), DycActActivitySupplierInfoBO.class));
                        item.setSupplierName(supplierInfos.get(0).getSupplierName());
                    }
                });
            }
        }

        return rspBo;
    }

    @Override
    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        return dycActActivityRepository.queryActivityList(reqBO);
    }

    @Override
    public List<DycActivityFileInfo> queryActivityFileList(DycActivityDO reqBO) {
        return dycActFileRepository.queryActivityFileList(reqBO);
    }

    /**
     * 活动可选供应商列表分页查询服务
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActivitySupplierInfo> queryActivityUnselectSupplierPageList(DycActivityDO reqBO) {
        return dycActActivitySupplierRepository.queryActivityUnselectSupplierPageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivitySupplierInfo> queryActiveSupplierList(DycActivityDO reqBO) {
        return dycActActivitySupplierRepository.queryActiveSupplierList(reqBO);
    }

    /**
     * 描述: 供应商批量更新
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    @Override
    public DycActivitySupplierInfo addBatchActiveSupplier(DycActivitySupplierInfoAddBatchBO reqBO) {
        return dycActActivitySupplierRepository.addBatchActiveSupplier(reqBO);
    }

    /**
     * 描述: 供应商批量删除
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    @Override
    public DycActivitySupplierInfo deleteBatchActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO) {
        return dycActActivitySupplierRepository.deleteBatchActiveSupplier(reqBO);
    }

    /**
     * 描述: 活动基本详情保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityFileInfo
     */
    @Override
    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        log.info("入参开始：{}", JSON.toJSONString(reqBO));
        DycActivityBaseInfo baseInfo = dycActActivityRepository.saveActiveBaseInfo(reqBO);
        if (null != reqBO.getActivityId() && !CollectionUtils.isEmpty(reqBO.getActivitySupplierList())) {
            DycActivitySupplierInfoDeleteBatchBO deleteBO = new DycActivitySupplierInfoDeleteBatchBO();
            deleteBO.setActivityId(reqBO.getActivityId());
            dycActActivitySupplierRepository.deleteActiveSupplier(deleteBO);

            DycActivitySupplierInfoAddBatchBO addBatchBO = new DycActivitySupplierInfoAddBatchBO();
            addBatchBO.setActivityId(reqBO.getActivityId());
            addBatchBO.setSupplierList(reqBO.getActivitySupplierList());
            dycActActivitySupplierRepository.addBatchActiveSupplier(addBatchBO);
        }
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        rspBO.setActivityId(baseInfo.getActivityId());
        return rspBO;

    }

    /**
     * 描述:活动已选商品池列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo
     */
    @Override
    public BasePageRspBo<DycActivityCommodityPoolInfo> queryActivityCommodityPoolPageList(DycQueryActivityCommodityPoolPageListReqBO reqBO) {
        return dycActActivityCommodityRepository.queryActivityCommodityPoolPageList(reqBO);
    }

    /**
     * 活动已选商品列表分页查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.queryActivityCommodityPageList(reqBO);
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> queryActivityCommodityList(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.queryActivityCommodityList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogList(DycActiveCommodityCatalogQueryBO reqBO) {
        return dycActActivityCommodityRepository.queryActiveCommodityCatalogList(reqBO);
    }

    @Override
    public DycActivityCommodityPoolInfo batchSelectActivityCommodityPool(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.batchSelectActivityCommodityPool(reqBO);
    }

    /**
     * 活动商品池移除（批量）服务
     *
     * @param reqBO
     * @return
     */
    @Override
    public int batchRemoveActivityCommodityPool(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.batchRemoveActivityCommodityPool(reqBO);
    }


    @Override
    public DycActiveCommodityCatalogInfo batchSelectActivityCommodityCatalog(DycActivityDO reqBO) {
        DycActiveCommodityCatalogInfo rspBO = dycActActivityCommodityRepository.batchSelectActivityCommodityCatalog(reqBO);

        //变更商品类目后需要同步到活动主表中去
        int commodityCatalog = dycActActivityCommodityRepository.selectCountCommodityCatalog(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        activityDO.setTotalCatalog(commodityCatalog);
        dycActActivityRepository.updateActivityState(activityDO);
        return rspBO;
    }

    @Override
    public int batchRemoveActivityCommodityCatalog(DycActivityDO reqBO) {
        int i = dycActActivityCommodityRepository.batchRemoveActivityCommodityCatalog(reqBO);

        //变更商品类目后需要同步到活动主表中去
        int commodityCatalog = dycActActivityCommodityRepository.selectCountCommodityCatalog(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        activityDO.setTotalCatalog(commodityCatalog);
        dycActActivityRepository.updateActivityState(activityDO);
        return i;
    }

    @Override
    public DycActActivityRelaCommodityInfo batchSelectActivityCommodity(DycActivityDO reqBO) {
        DycActActivityRelaCommodityInfo rspBO = dycActActivityCommodityRepository.batchSelectActivityCommodity(reqBO);

        //变更商品数量后需要同步到活动主表中去
        int countCommodity = dycActActivityCommodityRepository.selectCountCommodity(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        activityDO.setTotalCommodity(countCommodity);
        dycActActivityRepository.updateActivityState(activityDO);

        return rspBO;
    }

    @Override
    public int batchRemoveActivityCommodity(DycActivityDO reqBO) {
        int rspBO = dycActActivityCommodityRepository.batchRemoveActivityCommodity(reqBO);

        //变更商品数量后需要同步到活动主表中去
        int countCommodity = dycActActivityCommodityRepository.selectCountCommodity(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        activityDO.setTotalCommodity(countCommodity);
        dycActActivityRepository.updateActivityState(activityDO);
        return rspBO;
    }

    @Override
    public DycSaasActQueryActivityUserPageListRspBO queryActivityUserPageList(DycActivityDO reqBO) {
        DycSaasActQueryActivityUserPageListRspBO rspBo = dycActActivityUserRepository.queryActivityUserPageList(reqBO);
        rspBo.setTotalScores(dycActActivityUserRepository.selectCountUserScores(reqBO));
        return rspBo;
    }

    @Override
    public int changeActivityState(DycActivityDO reqBO) {
        return dycActActivityRepository.changeActivityState(reqBO);
    }

    @Override
    public int deleteActivity(DycActivityDO reqBO) {
        int i = dycActActivityRepository.deleteActivity(reqBO);
        dycActActivityCommodityRepository.deleteActivityCommodityCatalog(reqBO);
        dycActActivityCommodityRepository.deleteActivityCommodity(reqBO);
        dycActActivityUserRepository.deleteActivityUser(reqBO);
        return i;
    }

    @Override

    public DycActivityBaseInfo copyActivity(DycActivityDO reqBO) {

        //查询活动表
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        List<DycActivityBaseInfo> baseInfos = dycActActivityRepository.queryActivityList(activityDO);
        if (1 != baseInfos.size()) {
            throw new ZTBusinessException("当前活动id，存在多条活动！");
        }
        //附件表查询
        DycActivityDO aDo = new DycActivityDO();
        aDo.setObjId(reqBO.getActivityId());
        aDo.setObjType(1);
        List<DycActivityFileInfo> fileInfos = dycActFileRepository.queryActivityFileList(aDo);
        //活动表的复制
        DycActiveBaseInfoSaveReqBO infoSaveReqBO = JSON.parseObject(JSON.toJSONString(baseInfos.get(0)), DycActiveBaseInfoSaveReqBO.class);
        infoSaveReqBO.setFileInfoBOS(fileInfos);
        infoSaveReqBO.setCreateUserId(reqBO.getCreateUserId());
        infoSaveReqBO.setCreateUserName(reqBO.getCreateUserName());
        infoSaveReqBO.setActivityId(null);
        DycActivityBaseInfo dycActivityBaseInfo = saveActiveBaseInfo(infoSaveReqBO);

        //活动关联商品查询以及复制
        BasePageRspBo<DycActActivityRelaCommodityInfo> infoBasePageRspBo = dycActActivityCommodityRepository.queryActivityCommodityPageList(activityDO);
        if (infoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setActActivityRelaCommodityBOS(infoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            dycActActivityCommodityRepository.batchSelectActivityCommodity(commodityDo);
        }
        //活动关联商品池查询以及复制
        DycQueryActivityCommodityPoolPageListReqBO poolPageListReqBO = new DycQueryActivityCommodityPoolPageListReqBO();
        poolPageListReqBO.setActivityId(reqBO.getActivityId());
        BasePageRspBo<DycActivityCommodityPoolInfo> poolInfoBasePageRspBo = dycActActivityCommodityRepository.queryActivityCommodityPoolPageList(poolPageListReqBO);
        if (poolInfoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setActivityCommodityPoolInfos(poolInfoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            dycActActivityCommodityRepository.batchSelectActivityCommodityPool(commodityDo);
        }
        //活动关联商品类型查询以及复制
        DycActiveCommodityCatalogQueryBO catalogQueryBO = new DycActiveCommodityCatalogQueryBO();
        catalogQueryBO.setActivityId(reqBO.getActivityId());
        BasePageRspBo<DycActiveCommodityCatalogInfo> catalogInfoBasePageRspBo = dycActActivityCommodityRepository.queryActiveCommodityCatalogList(catalogQueryBO);
        if (catalogInfoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setCommodityCatalogInfoBOS(catalogInfoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            dycActActivityCommodityRepository.batchSelectActivityCommodityCatalog(commodityDo);
        }
        //活动关联供应商查询以及复制
        BasePageRspBo<DycActivitySupplierInfo> supplierInfoBasePageRspBo = dycActActivitySupplierRepository.queryActiveSupplierList(activityDO);
        if (supplierInfoBasePageRspBo.getRows().size() > 0) {
            DycActivitySupplierInfoAddBatchBO infoAddBatchBO = new DycActivitySupplierInfoAddBatchBO();
            infoAddBatchBO.setActivityId(dycActivityBaseInfo.getActivityId());
            infoAddBatchBO.setSupplierList(supplierInfoBasePageRspBo.getRows());
            dycActActivitySupplierRepository.addBatchActiveSupplier(infoAddBatchBO);
        }
        //活动关联用户查询以及复制
        DycSaasActQueryActivityUserPageListRspBO userInfoBasePageRspBo = dycActActivityUserRepository.queryActivityUserPageList(activityDO);
        if (userInfoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO userDO = new DycActivityDO();
            userDO.setCreateUserName(reqBO.getCreateUserName());
            userDO.setCreateUserId(reqBO.getCreateUserId());
            userDO.setActivityId(reqBO.getActivityId());
            userDO.setActivityUserList(userInfoBasePageRspBo.getRows());
            dycActActivityUserRepository.batchSelectActivityUser(userDO);
        }
        return dycActivityBaseInfo;
    }

    @Override
    public DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO) {

        //过滤已经添加的用户
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        List<DycActivityUserInfo> infos = dycActActivityUserRepository.queryActivityUserList(activityDO);
        Map<String, DycActivityUserInfo> userInfoMap = infos.stream().collect(Collectors.toMap(DycActivityUserInfo::getActUserName, item -> item));
        reqBO.getActivityUserList().forEach(item -> {
            if (!ObjectUtils.isEmpty(userInfoMap.get(item.getActUserName()))) {
                throw new ZTBusinessException("选择的用户，在已选列表中存在！");
            }
        });

        DycActivityUserInfo rspBO = dycActActivityUserRepository.batchSelectActivityUser(reqBO);

        int countUser = dycActActivityUserRepository.selectCountUser(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalUser(countUser);
        dycActActivityRepository.updateActivityState(aDo);
        return rspBO;
    }

    @Override
    public DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO) {
        DycActivityUserInfo rspBO = dycActActivityUserRepository.batchRemoveActivityUser(reqBO);

        int countUser = dycActActivityUserRepository.selectCountUser(reqBO);
        BigDecimal decimal = dycActActivityUserRepository.selectCountUserScores(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalUser(countUser);
        aDo.setTotalScores(decimal);
        dycActActivityRepository.updateActivityState(aDo);
        return rspBO;
    }

    @Override
    public DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO) {
        DycActivityUserInfo rspBO = dycActActivityUserRepository.modifyActivityUserScores(reqBO);

        BigDecimal decimal = dycActActivityUserRepository.selectCountUserScores(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalScores(decimal);
        dycActActivityRepository.updateActivityState(aDo);

        return rspBO;
    }

    @Override
    public DycActImportActivityUserModelRspBO importActivityUser(DycActImportActivityUserModelReqBO reqBO) {
        DycActImportActivityUserModelRspBO rspBO = new DycActImportActivityUserModelRspBO();
        if (CollectionUtils.isEmpty(reqBO.getUserInfoList())) {
            throw new ZTBusinessException("没有需要增加的用户");
        }
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id为空");
        }
        DycActivityBaseInfo dycActivityBaseInfo = new DycActivityBaseInfo();
        dycActivityBaseInfo.setActivityId(reqBO.getActivityId());
        dycActivityBaseInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityBaseInfo modelByNew = dycActActivityRepository.getModelByNew(dycActivityBaseInfo);
        if (modelByNew == null || modelByNew.getActivityId() == null) {
            throw new ZTBusinessException("该活动不存在");
        }
        //查询活动已选用户
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        List<DycActivityUserInfo> dycActivityUserInfos = dycActActivityUserRepository.queryActivityUserList(dycActivityDO);

        Set<String> collect = new HashSet<>();
        if (!CollectionUtils.isEmpty(dycActivityUserInfos)) {
            collect = dycActivityUserInfos.stream().map(DycActivityUserInfo::getActUserName).collect(Collectors.toSet());
        }

        List<DycActivityUserInfo> addList = new ArrayList<>();
        //得到需要添加的用户
        for (DycActActivityUserInfoBO infoBO : reqBO.getUserInfoList()) {
            // 存在更新
            if (!collect.isEmpty() && collect.contains(infoBO.getActUserName())) {
                DycActivityUserInfo dycActivityUserInfo = new DycActivityUserInfo();
                dycActivityUserInfo.setGiveScores(infoBO.getGiveScores());
                dycActivityUserInfo.setBalanceScores(infoBO.getBalanceScores());
                dycActivityUserInfo.setUpdateTime(new Date());
                dycActivityUserInfo.setUpdateUserId(reqBO.getUserId());
                dycActivityUserInfo.setUpdateUserName(reqBO.getName());
                dycActivityUserInfo.setCreateUserId(null);
                dycActivityUserInfo.setCreateUserName(null);
                dycActivityUserInfo.setCreateTime(null);
                dycActActivityUserRepository.updateActivityUser(dycActivityUserInfo);
            } else {
                DycActivityUserInfo dycActivityUserInfo = ActRu.js(infoBO, DycActivityUserInfo.class);
                addList.add(dycActivityUserInfo);
            }
        }
        //新增用户
        if (!CollectionUtils.isEmpty(addList)) {
            dycActivityDO.setActivityUserList(addList);
            dycActivityDO.setCreateUserId(reqBO.getUserId());
            dycActivityDO.setCreateUserName(reqBO.getName());
            dycActActivityUserRepository.batchSelectActivityUser(dycActivityDO);
        }
        DycActivityBaseInfo set = new DycActivityBaseInfo();
        set.setUpdateTime(new Date());
        set.setUpdateUserId(reqBO.getUserId());
        set.setUpdateUserName(reqBO.getName());
        DycActivityBaseInfo where = new DycActivityBaseInfo();
        where.setActivityId(reqBO.getActivityId());
        dycActActivityRepository.updateByNew(set, where);
        return rspBO;
    }

    /**
     * 商品校验
     *
     * @param list
     * @param info
     * @param skuInfoBO
     * @return
     */
    private Boolean checkSku(List<DycActImportActivityInfoModelBO> list, DycActImportActivityCommodityInfo info, ActSkuInfoBO skuInfoBO) {
        DycActImportActivityInfoModelBO dycActImportActivityInfoModelBO = new DycActImportActivityInfoModelBO();
        if (skuInfoBO == null) {
            dycActImportActivityInfoModelBO.setLineNum(info.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("未找到商品");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }
        if (!DycActivityConstants.SkuStatue.ON_SALE.equals(skuInfoBO.getSkuStatus())) {
            dycActImportActivityInfoModelBO.setLineNum(info.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("商品状态不为已上架");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }
        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId1Status())) {
            dycActImportActivityInfoModelBO.setLineNum(info.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("商品一级类目已停用");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }

        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId2Status())) {
            dycActImportActivityInfoModelBO.setLineNum(info.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("商品二级类目已停用");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }

        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId3Status())) {
            dycActImportActivityInfoModelBO.setLineNum(info.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("商品三级级类目已停用");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }
        return false;
    }

    /**
     * 商品信息设置
     *
     * @return
     */
    private DycActActivityRelaCommodityInfo setCommodityInfo(ActSkuInfoBO skuInfoBO) {
        DycActActivityRelaCommodityInfo commodityInfo = new DycActActivityRelaCommodityInfo();
        commodityInfo.setSkuDetails(skuInfoBO.getSkuPcDetailUrl());
        commodityInfo.setSkuId(skuInfoBO.getSkuId());
        commodityInfo.setCommodityPoolName(skuInfoBO.getPoolNames());
        commodityInfo.setSkuCode(skuInfoBO.getSkuCode());
        commodityInfo.setSkuName(skuInfoBO.getSkuName());
        commodityInfo.setSkuUrl(skuInfoBO.getSkuUrl());
        commodityInfo.setSkuStatus(skuInfoBO.getSkuStatus());
        commodityInfo.setFirstCatalogId(String.valueOf(skuInfoBO.getCatalogId1()));
        commodityInfo.setFirstCatalogName(skuInfoBO.getCatalogName1());
        commodityInfo.setSecondCatalogId(String.valueOf(skuInfoBO.getCatalogId2()));
        commodityInfo.setSecondCatalogName(skuInfoBO.getCatalogName2());
        commodityInfo.setThreeCatalogId(String.valueOf(skuInfoBO.getCatalogId3()));
        commodityInfo.setThreeCatalogName(skuInfoBO.getCatalogName3());
        commodityInfo.setCterminalUrl(skuInfoBO.getJdSkuUrl());
        commodityInfo.setBrand(skuInfoBO.getBrandName());
        commodityInfo.setPrice(skuInfoBO.getAgreementPrice());
        if (skuInfoBO.getGoodRate() != null) {
            commodityInfo.setFavorableRate(skuInfoBO.getGoodRate().doubleValue());
        }
        return commodityInfo;
    }

    @Override
    public DycActImportActivityCommodityModelRspBO importActivityCommodity(DycActImportActivityCommodityModelReqBO reqBO) {

        DycActImportActivityCommodityModelRspBO rspBO = new DycActImportActivityCommodityModelRspBO();
        List<DycActImportActivityInfoModelBO> list = new ArrayList<>();
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参为空");
        }

        //得到活动id、操作人id、操作人名称
        Long activityId = reqBO.getActivityId();
        Long userId = reqBO.getUserId();
        String name = reqBO.getName();
        if (activityId == null || userId == null || StringUtils.isEmpty(name)) {
            throw new ZTBusinessException("入参为空");
        }
        DycActivityBaseInfo dycActivityBaseInfo = new DycActivityBaseInfo();
        dycActivityBaseInfo.setActivityId(activityId);
        dycActivityBaseInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityBaseInfo modelByNew = dycActActivityRepository.getModelByNew(dycActivityBaseInfo);
        if (modelByNew == null || modelByNew.getActivityId() == null) {
            throw new ZTBusinessException("该活动不存在");
        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(Long.valueOf(activityId));
        dycActivityDO.setCommodityRelaMethod(Integer.valueOf(DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_THREE));
        List<DycActActivityRelaCommodityInfo> commodityInfos = dycActActivityCommodityRepository.queryActivityCommodityList(dycActivityDO);
        Map<String, DycActActivityRelaCommodityInfo> collect = commodityInfos.stream().collect(Collectors.toMap(DycActActivityRelaCommodityInfo::getSkuCode, v -> v));
        if (CollectionUtils.isEmpty(reqBO.getCommodityItem())) {
            throw new ZTBusinessException("没有需要增加的商品");
        }
        List<String> skuCodes = reqBO.getCommodityItem().stream().map(DycActImportActivityCommodityInfo::getSkuCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuCodes)) {
            for (DycActImportActivityCommodityInfo info : reqBO.getCommodityItem()) {
                DycActImportActivityInfoModelBO dycActImportActivityInfoModelBO = new DycActImportActivityInfoModelBO();
                dycActImportActivityInfoModelBO.setLineNum(info.getGluttonLineNum());
                dycActImportActivityInfoModelBO.setFailReason("商品编码必填");
                list.add(dycActImportActivityInfoModelBO);
            }
            rspBO.setFailReasonList(list);
            return rspBO;
        }

        Map<String, ActSkuInfoBO> infoBOMap = dycActSkuInfoRepository.queryActSkuInfoByCodeList(skuCodes);
        DycActivityDO dycActivityInfo = new DycActivityDO();
        dycActivityInfo.setActivityId(Long.valueOf(activityId));
        dycActivityInfo.setCreateUserId(Long.valueOf(userId));
        dycActivityInfo.setCreateUserName(name);
        List<DycActActivityRelaCommodityInfo> actActivityRelaCommodityBOS = new ArrayList<>();
        List<DycActActivityRelaCommodityInfo> updateList = new ArrayList<>();
        for (DycActImportActivityCommodityInfo o : reqBO.getCommodityItem()) {

            //商品信息
            ActSkuInfoBO skuInfoBO = infoBOMap.get(o.getSkuCode());
            //商品校验
            if (checkSku(list, o, skuInfoBO)) {
                continue;
            }
            //如果已经存在就更新
            if (collect.size() > 0 && collect.containsKey(o.getSkuCode())) {
                DycActActivityRelaCommodityInfo commodityInfo = setCommodityInfo(skuInfoBO);
                commodityInfo.setActivityId(Long.valueOf(activityId));
                commodityInfo.setUpdateTime(new Date());
                commodityInfo.setUpdateUserName(name);
                commodityInfo.setUpdateUserId(Long.valueOf(userId));
                commodityInfo.setCreateTime(null);
                commodityInfo.setCreateUserName(null);
                commodityInfo.setCreateUserId(null);
                updateList.add(commodityInfo);
            } else {
                DycActActivityRelaCommodityInfo commodityInfo = setCommodityInfo(skuInfoBO);
                actActivityRelaCommodityBOS.add(commodityInfo);
            }
        }
        boolean check = true;
        //新增活动商品
        if (!CollectionUtils.isEmpty(actActivityRelaCommodityBOS)) {
            //去重
            actActivityRelaCommodityBOS = actActivityRelaCommodityBOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(DycActActivityRelaCommodityInfo::getSkuCode))), ArrayList::new));
            dycActivityInfo.setActActivityRelaCommodityBOS(actActivityRelaCommodityBOS);
            dycActivityInfo.setCreateUserName(reqBO.getName());
            dycActivityInfo.setCreateUserId(reqBO.getUserId());
            dycActActivityCommodityRepository.batchSelectActivityCommodity(dycActivityInfo);
            //更新商品总数
            int totalCommodity = actActivityRelaCommodityBOS.size();
            if (!CollectionUtils.isEmpty(commodityInfos)) {
                totalCommodity = totalCommodity + commodityInfos.size();
            }
            DycActivityBaseInfo set = new DycActivityBaseInfo();
            set.setTotalCommodity(totalCommodity);
            set.setUpdateTime(new Date());
            set.setUpdateUserId(userId);
            set.setUpdateUserName(name);
            DycActivityBaseInfo where = new DycActivityBaseInfo();
            where.setActivityId(activityId);
            dycActActivityRepository.updateByNew(set, where);
            check = false;
        }
        //更新活动商品
        if (!CollectionUtils.isEmpty(updateList)) {
            for (DycActActivityRelaCommodityInfo commodityInfo : updateList) {
                dycActActivityCommodityRepository.updateCommodity(commodityInfo);
            }
            if (check) {
                DycActivityBaseInfo set = new DycActivityBaseInfo();
                set.setUpdateTime(new Date());
                set.setUpdateUserId(userId);
                set.setUpdateUserName(name);
                DycActivityBaseInfo where = new DycActivityBaseInfo();
                where.setActivityId(activityId);
                dycActActivityRepository.updateByNew(set, where);
            }
        }
        rspBO.setFailReasonList(list);
        return rspBO;
    }

    @Override
    public List<Long> autoEffectActivity(DycActivityDO reqBO) {
        return dycActActivityRepository.autoEffectActivity(reqBO);
    }

    @Override
    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        return dycActActivityRepository.autoLoseEffectActivity(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO) {
        return dycActActivityUserRepository.queryActivityUserScoresUseRecordPageList(reqBO);
    }

    @Override
    public int deductOrReturnActivityScores(DycActivityDO reqBO) {
        return dycActActivityUserRepository.deductOrReturnActivityScores(reqBO);
    }

    @Override
    public List<DycActSceneInfo> queryActivityScene(DycActSceneInfoDO reqBO) {
        return dycActConfigRepository.queryActivityScene(reqBO);
    }

    @Override
    public int updateActivityState(DycActivityDO reqBO) {
        return dycActActivityRepository.updateActivityState(reqBO);
    }

    @Override
    public List<DycActivitySupplierInfo> queryActivitySelectableSupplierList(DycActivityDO reqBO) {
        return dycActActivitySupplierRepository.queryActiveSupplierAllList(reqBO);
    }

    @Override
    public DycActivityFileInfo saveActFileInfo(DycActivityFileInfo reqBO) {
        return dycActFileRepository.saveActivityFileInfo(reqBO);
    }

    @Override
    public int deleteActFileInfo(DycActivityFileInfo reqBO) {
        return dycActFileRepository.deleteActivityFileInfo(reqBO);
    }

    @Override
    public DycActivityFileInfo qryActFileInfo(DycActivityFileInfo reqBO) {
        return dycActFileRepository.queryActivityFile(reqBO);
    }

    @Override
    public int quoteActivityCommodity(DycActivityDO reqBO) {
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getQuoteActivityId());
        List<DycActActivityRelaCommodityInfo> commodityInfos = dycActActivityCommodityRepository.selectByOnShelf(activityDO);

        //过滤调已有的商品
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setCommodityRelaMethod(3);
        List<DycActActivityRelaCommodityInfo> relaCommodityInfos = dycActActivityCommodityRepository.queryActivityCommodityList(dycActivityDO);

        Set<Long> idSet = relaCommodityInfos.stream()
                .map(DycActActivityRelaCommodityInfo::getSkuId)
                .collect(Collectors.toSet());

        List<DycActActivityRelaCommodityInfo> filter = commodityInfos.stream()
                .filter(item -> !idSet.contains(item.getSkuId()))
                .collect(Collectors.toList());

        reqBO.setActActivityRelaCommodityBOS(filter);
        dycActActivityCommodityRepository.batchSelectActivityCommodity(reqBO);

        //变更商品数量后需要同步到活动主表中去
        int countCommodity = dycActActivityCommodityRepository.selectCountCommodity(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalCommodity(countCommodity);
        dycActActivityRepository.updateActivityState(aDo);

        return 0;
    }

    @Override
    public List<DycActActivityInfo> qryActInfoByUserId(DycActQryActInfoByUserQryDO reqBO) {
        return dycActActivityUserRepository.qryActInfoByUserId(reqBO);
    }

    @Override
    public int addBatchActivitySyncExternalRecord(List<ActActivitySyncExternalRecordDO> reqBO) {
        return dycActActivitySyncExternalRecordRepository.addBatchActivitySyncExternalRecord(reqBO);
    }

    @Override
    public ActActivitySyncExternalRecordInfo updateActivitySyncExternalRecord(ActActivitySyncExternalRecordDO reqBO) {
        return dycActActivitySyncExternalRecordRepository.updateActivitySyncExternalRecord(reqBO);
    }

    @Override
    public ActActivitySyncExternalRecordInfo queryActivitySyncExternalRecordSingle(ActActivitySyncExternalRecordDO reqBO) {
        return dycActActivitySyncExternalRecordRepository.queryActivitySyncExternalRecordSingle(reqBO);
    }

    @Override
    public List<ActActivitySyncExternalRecordInfo> queryActivitySyncExternalRecordList(ActActivitySyncExternalRecordDO reqBO) {
        return dycActActivitySyncExternalRecordRepository.queryActivitySyncExternalRecordList(reqBO);
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserList(DycActivityDO reqBO) {
        return dycActActivityUserRepository.queryActivityUserList(reqBO);
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserNotInPoolList(DycActivityDO reqBO) {
        return dycActActivityUserRepository.queryActivityUserNotInPoolList(reqBO);
    }

    /**
     * 用户积分信息查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActUserScoresBaseInfo> queryUserScoresPageList(DycActUserScoresBaseInfoQueryBO reqBO) {
        return dycActActivityUserRepository.queryUserScoresPageList(reqBO);
    }

    @Override
    public DycActivityBaseInfo getActivityBaseInfoDetail(DycActivityDO dycActivityDO) {
        return dycActActivityRepository.getActivityBaseInfoDetail(dycActivityDO);
    }

    @Override
    public int updateCommodityState(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.updateCommodityState(reqBO);
    }

    @Override
    public int delEmptyActivityCommodityCatalog(DycActiveCommodityCatalogInfo reqBo) {
        int i = dycActActivityCommodityRepository.updateActiveCommodityCatalogInfoBy(reqBo);
        //该服务就是更新活动数据（只是服务名取的有问题）
        if (i > 0) {
            DycActivityDO activityDO = new DycActivityDO();
            activityDO.setActivityId(reqBo.getActivityId());
            activityDO.setTotalCatalog(0);
            dycActActivityRepository.updateActivityState(activityDO);
        }
        return i;
    }

    @Override
    public int updateActivityUserInfoBy(DycActivityUserInfo setBo, DycActivityUserInfo whereBo) {
        return dycActActivityUserRepository.updateByNew(setBo, whereBo);
    }

    @Override
    public DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO) {
        DycActivityUserInfo rspBO = dycActActivityUserRepository.batchModifyActivityUserScores(reqBO);

        BigDecimal decimal = dycActActivityUserRepository.selectCountUserScores(reqBO);
        //该服务就是更新活动数据（只是服务名取的有问题）
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalScores(decimal);
        dycActActivityRepository.updateActivityState(aDo);

        return rspBO;
    }

    @Override
    public DycActCheckUserNotScoreRspBo qryCheckUserNotScore(DycActCheckUserNotScoreReqBo reqBo) {
        DycActCheckUserNotScoreRspBo dycActCheckUserNotScoreRspBo = new DycActCheckUserNotScoreRspBo();
        DycActivityUserInfo dycActivityUserInfo = new DycActivityUserInfo();
        dycActivityUserInfo.setActivityId(reqBo.getActivityId());
        int checkByNewByCheck = dycActActivityUserRepository.getCheckByNewByCheck(dycActivityUserInfo);
        if (checkByNewByCheck > 0) {
            dycActCheckUserNotScoreRspBo.setIsNot(true);
        } else {
            dycActCheckUserNotScoreRspBo.setIsNot(false);
        }
        return dycActCheckUserNotScoreRspBo;
    }

    @Override
    public BasePageRspBo<DycActUserScoresBaseInfo> qryActivityUserInfoPageList(DycActUserScoresBaseInfoQueryBO queryBO) {
        return dycActActivityUserRepository.qryActivityUserInfoPageList(queryBO);
    }

    @Override
    public int selectNotUsedScores(DycActivityDO reqBO) {
        return dycActActivityUserRepository.selectNotUsedScores(reqBO);
    }
}
