package com.tydic.dyc.act.model.impl;

import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.service.api.DycActDealOrderAlertService;
import com.tydic.dyc.act.service.bo.DycActDealOrderAlertReqBO;
import com.tydic.dyc.act.service.bo.DycActDealOrderAlertRspBO;
import com.tydic.dyc.act.service.bo.DycActUpdateAlertInfoBO;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.stream.Collectors;

/**
 * @ClassName DycActDealOrderAlertServiceImpl
 * @Author 14051
 * @Date 2024/4/16 17:13
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActDealOrderAlertServiceImpl implements DycActDealOrderAlertService {

    @Autowired
    private DycActOrderModel dycActOrderModel;
    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActDealOrderAlertRspBO dealOrderAlert(DycActDealOrderAlertReqBO reqBO) {
        if (reqBO.getObjType() == 1){
            //订单
            DycActDealOrderAlertDO dycActDealOrderAlertDO = new DycActDealOrderAlertDO();
            BeanUtils.copyProperties(reqBO, dycActDealOrderAlertDO);
            dycActOrderModel.dealOrderAlert(dycActDealOrderAlertDO);
        } else if (reqBO.getObjType() == 2){
            //服务单
            DycActDealOrderAlertDO dycActDealOrderAlertDO = new DycActDealOrderAlertDO();
            BeanUtils.copyProperties(reqBO, dycActDealOrderAlertDO);
            dycActOrderModel.dealAfsOrderAlert(dycActDealOrderAlertDO);
        } else if (reqBO.getObjType() == 3){
            //结算单
            DycActDealOrderAlertDO dycActDealOrderAlertDO = new DycActDealOrderAlertDO();
            BeanUtils.copyProperties(reqBO, dycActDealOrderAlertDO);
            dycActFscOrderModel.dealFscOrderAlert(dycActDealOrderAlertDO);
        }

        return new DycActDealOrderAlertRspBO();
    }

    @Override
    public DycActDealOrderAlertRspBO dealUpdOrderAlert(DycActDealOrderAlertReqBO reqBO) {
        if (reqBO.getObjType() == 1){
            //订单
            DycActDealOrderAlertDO dycActDealOrderAlertDO = JUtil.js(reqBO, DycActDealOrderAlertDO.class);
            dycActDealOrderAlertDO.setAlertType(null);
            dycActDealOrderAlertDO.setOrderIds(reqBO.getUpdAlertInfoList().stream().map(DycActUpdateAlertInfoBO::getOrderId).collect(Collectors.toList()));
            dycActOrderModel.dealUpdOrderAlert(dycActDealOrderAlertDO);
        } else if (reqBO.getObjType() == 2){
            //服务单
            DycActDealOrderAlertDO dycActDealOrderAlertDO = JUtil.js(reqBO, DycActDealOrderAlertDO.class);
            dycActDealOrderAlertDO.setAlertType(null);
            dycActDealOrderAlertDO.setOrderIds(reqBO.getUpdAlertInfoList().stream().map(DycActUpdateAlertInfoBO::getOrderId).collect(Collectors.toList()));
            dycActOrderModel.dealUpdAfsOrderAlert(dycActDealOrderAlertDO);
        }

        return new DycActDealOrderAlertRspBO();
    }
}
