package com.tydic.dyc.act.model.impl;

import com.tydic.dyc.act.model.api.DycActFscInvoiceModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActFscInvoiceRepository;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @ClassName DycActFscInvoiceModelImpl
 * @Author 14051
 * @Date 2024/4/3 11:27
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActFscInvoiceModelImpl implements DycActFscInvoiceModel {

    @Autowired
    private DycActFscInvoiceRepository dycActFscInvoiceRepository;

    @Override
    public BasePageRspBo<DycActFscInvoiceItemInfo> qryInvoiceItemList(DycActFscInvoiceDO reqBO) {
        return dycActFscInvoiceRepository.qryInvoiceItemList(reqBO);
    }

    @Override
    public DycActFscInvoiceInfo getInvoiceInfoByInvoiceNo(DycActFscInvoiceDO reqBO) {
        return dycActFscInvoiceRepository.getInvoiceInfoByInvoiceNo(reqBO);
    }

    @Override
    public BasePageRspBo<DycActFscInvoiceInfo> qryInvoiceList(DycActFscInvoiceDO reqBO) {
        return dycActFscInvoiceRepository.qryInvoiceList(reqBO);
    }

    @Override
    public List<DycActFscInvoiceAmt> getInvoiceAmtByFscOrderIds(DycActFscInvoiceAmtDO reqBO) {
        return dycActFscInvoiceRepository.getInvoiceAmtByFscOrderIds(reqBO);
    }

    @Override
    public DycActFscInvoiceInfo getSumAmtByFscOrderId(DycActFscInvoiceDO reqBO) {
        return dycActFscInvoiceRepository.getSumAmtByFscOrderId(reqBO);
    }

    @Override
    public void saveFscInvoices(DycActFscInvoiceDO reqBO) {
        //先删除原有的数据
        dycActFscInvoiceRepository.deleteFscInvoice(reqBO);
        //保存新数据
        dycActFscInvoiceRepository.saveFscInvoices(reqBO);
    }

    @Override
    public void saveFscInvoiceItem(DycActFscInvoiceItemDO reqBO) {
        //先删除原有的数据
        dycActFscInvoiceRepository.deleteFscInvoiceItem(reqBO);
        //保存新数据
        dycActFscInvoiceRepository.saveFscInvoicesItem(reqBO);
    }

    @Override
    public int updateFscInvoiceFlag(DycActFscInvoiceItemDO reqBO) {
        return dycActFscInvoiceRepository.updateFscInvoiceFlag(reqBO);
    }

    @Override
    public int getCountUnGetItem(DycActFscInvoiceItemDO reqBO) {
        return dycActFscInvoiceRepository.getCountUnGetItem(reqBO);
    }

}
