package com.tydic.dyc.act.model.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.*;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * @ClassName DycActFscOrderModelImpl
 * @Author 14051
 * @Date 2024/4/2 20:25
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActFscOrderModelImpl implements DycActFscOrderModel {

    @Autowired
    private DycActFscOrderRepository dycActFscOrderRepository;
    @Autowired
    private DycActFscOrderRelationRepository dycActFscOrderRelationRepository;
    @Autowired
    private DycActFscOrderInvoiceRepository dycActFscOrderInvoiceRepository;
    @Autowired
    private DycActFscCheckResultRepository dycActFscCheckResultRepository;
    @Autowired
    private DycActAlertInfoRepository dycActAlertInfoRepository;

    @Override
    public int dealPayOrderState(DycActFscOrderDO reqBO) {
        return dycActFscOrderRepository.dealPayOrderState(reqBO);
    }

    @Override
    public int dealSignOrderState(DycActFscOrderSignDO reqBO) {
        return dycActFscOrderRepository.dealSignOrderState(reqBO);
    }

    @Override
    public DycActFscOrderInfo getFscOrderOne(DycActFscOrderDO reqBO) {
        return dycActFscOrderRepository.getFscOrderOne(reqBO);
    }

    @Override
    public BasePageRspBo<DycActFscOrderInfo> selectByCondition(DycActFscOrderQryDO reqBO) {
        return dycActFscOrderRepository.selectByCondition(reqBO);
    }

    @Override
    public List<DycActFscOrderInfo> queryFscOrderList(DycActFscOrderQryDO qryDo) {
        return dycActFscOrderRepository.queryFscOrderList(qryDo);
    }

    @Override
    public List<DycActFscOrderFileInfo> selectFileListByIds(DycActFscOrderFileQryDO reqBO) {
        return dycActFscOrderRepository.selectFileListByIds(reqBO);
    }

    @Override
    public int getFscOrderNum(DycActFscOrderDO reqBO) {
        return dycActFscOrderRelationRepository.getFscOrderNum(reqBO);
    }

    @Override
    public DycActFscOrderInvoiceInfo selectOneFscOrderInvoice(DycActFscOrderDO reqBO) {
        return dycActFscOrderInvoiceRepository.selectOneFscOrderInvoice(reqBO);
    }

    @Override
    public BasePageRspBo<DycActFscRelOrderInfo> selectRelOrderByConditon(DycActFscRelOrderDO reqBO) {
        return dycActFscCheckResultRepository.selectByConditon(reqBO);
    }

    @Override
    public int dealFscOrderReject(DycActFscOrderDO reqBO) {
        return dycActFscOrderRepository.dealOrderState(reqBO);
    }

    @Override
    public int updateFscOrderLogisticsInfo(DycActFscOrderLogisticsInfoDO reqBO) {
        return dycActFscOrderRepository.updateLogisticsInfo(reqBO);
    }

    @Override
    public int dealFscOrderState(DycActFscOrderDO reqBO) {
        return dycActFscOrderRepository.dealOrderState(reqBO);
    }

    @Override
    public void dealFscOrdRelationCancel(DycActFscOrderDO reqBO) {
        dycActFscOrderRelationRepository.saveFscOrdRelationHis(reqBO);
        dycActFscOrderRelationRepository.deleteFscOrdRelation(reqBO);
    }

    @Override
    public DycActFscOrdSaveInfo saveFscOrder(DycActFscOrderSaveDO reqBO) {
        //保存主单基本信息
        DycActFscOrdSaveInfo dycActFscOrderInfo = dycActFscOrderRepository.saveFscOrder(reqBO);
        //保存结算单和订单关系表
        reqBO.setFscOrderId(dycActFscOrderInfo.getFscOrderId());
        dycActFscOrderRelationRepository.saveFscOrdRelation(reqBO);
        //保存发票和收票人信息
        DycActFscOrderInvoiceDO dycActFscOrderInvoiceDO = JUtil.js(reqBO.getInvoiceInfo(), DycActFscOrderInvoiceDO.class);
        BeanUtils.copyProperties(reqBO.getReceiveInfo(), dycActFscOrderInvoiceDO);
        dycActFscOrderInvoiceDO.setFscOrderId(dycActFscOrderInfo.getFscOrderId());
        dycActFscOrderInvoiceRepository.saveFscOrderInvoice(dycActFscOrderInvoiceDO);
        return dycActFscOrderInfo;
    }

    @Override
    public BasePageRspBo<DycActFscOrderRelationInfo> getFscOrderRelationList(DycActFscOrderQryDO reqBO) {
        return dycActFscOrderRelationRepository.getFscOrderRelationList(reqBO);
    }

    @Override
    public int updateRelationBatch(DycActFscOrderRelationDO reqBO) {
        return dycActFscOrderRelationRepository.updateRelationBatch(reqBO);
    }

    @Override
    public int saveBatchInfo(DycActFscOrderBatchInfoDO reqBO) {
        return dycActFscOrderRelationRepository.saveBatchInfo(reqBO);
    }

    @Override
    public int updateBatchInfo(DycActFscOrderBatchInfoDO reqBO) {
        return dycActFscOrderRelationRepository.updateBatchInfo(reqBO);
    }

    @Override
    public List<DycActFscOrderRelationInfo> getFscOrdRelationList(DycActFscOrderBatchInfoDO reqBO) {
        return dycActFscOrderRelationRepository.getFscOrdRelationList(reqBO);
    }

    @Override
    public BigDecimal getCurrentAmt(DycActFscOrderBatchInfoDO reqBO) {
        return dycActFscOrderRelationRepository.getCurrentAmt(reqBO);
    }

    @Override
    public int getFscPushFailNum(DycActFscOrderDO reqBO) {
        return dycActFscOrderRepository.getFscPushFailNum(reqBO);
    }

    @Override
    public int deleteFscOrderBatchInfo(DycActFscOrderDO reqBO) {
        return dycActFscOrderRelationRepository.deleteFscOrderBatchInfo(reqBO);
    }

    @Override
    public List<Long> qryAlertFscOrderList(DycActDealAlertQryOrderDO reqBO) {
        return dycActFscOrderRepository.qryAlertFscOrderList(reqBO);
    }

    @Override
    public void dealFscOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        //更新结算单的预警
        dycActFscOrderRepository.updateOrderAlertType(dycActDealOrderAlertDO);

        //写预警记录表
        dycActAlertInfoRepository.saveAlertInfo(dycActDealOrderAlertDO);
    }

    @Override
    public void dealUpdFscOrdAlertType(DycActFscOrderDO reqBO) {
        dycActFscOrderRepository.updateFscOrderAlertType(reqBO);

        //查询预警记录
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderDO.setOldAlertType(reqBO.getOldAlertType());
        ActAlertOrderInfo actAlertOrderInfo = dycActAlertInfoRepository.getAlertInfo(dycActFscOrderDO);
        if (actAlertOrderInfo != null) {
            DycActDealOrderAlertDO dycActDealOrderAlertDO = new DycActDealOrderAlertDO();
            dycActDealOrderAlertDO.setAlertState(DycActivityConstants.AlertState.DEALED);
            ActUpdateAlertInfo actUpdateAlertInfo = new ActUpdateAlertInfo();
            actUpdateAlertInfo.setId(actAlertOrderInfo.getId());
            dycActDealOrderAlertDO.setUpdAlertInfoList(Arrays.asList(actUpdateAlertInfo));
            dycActAlertInfoRepository.updateAlertInfo(dycActDealOrderAlertDO);
        }
    }

    /**
     * 获取预警结算单
     * @param qryDO
     * @return
     */
    @Override
    public List<DycActFscOrderDO> getFscOrderWarning(DycActFscOrderQryDO qryDO) {
        return dycActFscOrderRepository.getFscOrderWarning(qryDO);
    }
}
