package com.tydic.dyc.act.model.impl;

import com.tydic.dyc.act.model.api.DycActGuideModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActSkuGuideRepository;
import com.tydic.dyc.act.service.bo.*;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：DycActGuideModelImpl
 * 说明：
 * 时间：2024/4/9 17:03
 * 作者：Zhouhaifeng
 */
@Service
public class DycActGuideModelImpl implements DycActGuideModel {

    @Autowired
    private DycActSkuGuideRepository dycActSkuGuideRepository;

    @Override
    public DycActGuideDO queryCatalogTree(DycActGuideQryDO reqBO) {
        return dycActSkuGuideRepository.qryGuideTree(reqBO);
    }

    @Override
    public DycActQueryCatalogListRspBO getCatalogNotChildSearch(DycActQueryCatalogListReqBO reqBO) {
        return dycActSkuGuideRepository.getCatalogNotChildSearch(reqBO);
    }

    @Override
    public DycActAddCatalogRspBO addCategory(DycActAddCatalogReqBO reqBO) {
        ActSkuGuideRspBO actSkuGuideRspBO = dycActSkuGuideRepository.addActSkuGuide(JUtil.js(reqBO, ActSkuGuideReqBO.class));
        return JUtil.js(actSkuGuideRspBO,DycActAddCatalogRspBO.class);
    }

    @Override
    public DycActModifySkuCatalogRspBO modifySkuCatalog(DycActModifySkuCatalogReqBO reqBO) {
        ActSkuGuideRspBO actSkuGuideRspBO = dycActSkuGuideRepository.updateActSkuGuide(JUtil.js(reqBO, ActSkuGuideReqBO.class));
        return JUtil.js(actSkuGuideRspBO,DycActModifySkuCatalogRspBO.class);
    }

    @Override
    public DycActDeleteSkuCatalogRspBO deleteSkuCatalog(DycActDeleteSkuCatalogReqBO reqBO) {
        ActSkuGuideRspBO actSkuGuideRspBO = dycActSkuGuideRepository.deleteActSkuGuide(JUtil.js(reqBO, ActSkuGuideReqBO.class));
        return JUtil.js(actSkuGuideRspBO,DycActDeleteSkuCatalogRspBO.class);
    }

    @Override
    public DycActCheckDelSkuCatalogRspBO checkDelCatalog(DycActCheckDelSkuCatalogReqBO reqBO) {
        ActSkuGuideCheckDelReqBO reqBO1 = new ActSkuGuideCheckDelReqBO();
        reqBO1.setGuideCatalogId(reqBO.getGuideCatalogId());
        reqBO1.setCatalogLevel(reqBO.getCatalogLevel());
        ActSkuGuideCheckDelRspBO rspBO = dycActSkuGuideRepository.checkDelCatalog(reqBO1);
        return JUtil.js(rspBO,DycActCheckDelSkuCatalogRspBO.class);
    }

    @Override
    public DycActChangeCatalogOrderRspBO changeCatalogOrder(DycActChangeCatalogOrderReqBO reqBO) {
        ActSkuSortGuideRspBO rspBO = dycActSkuGuideRepository.changeCatalogOrder(JUtil.js(reqBO, ActSkuSortGuideReqBO.class));
        return JUtil.js(rspBO,DycActChangeCatalogOrderRspBO.class);
    }
}
