package com.tydic.dyc.act.model.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActIaborModel;
import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.model.bo.DycActLaborUnionInfo;
import com.tydic.dyc.act.repository.api.DycActlaborRepository;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：DycActIaborModelImpl
 * 说明：
 * 时间： 2024-03-26 15:46
 * 作者 @author LY
 */
@Slf4j
@Service
public class DycActIaborModelImpl implements DycActIaborModel {

    @Autowired
    private DycActlaborRepository dycActlaborRepository;

    @Override
    public int addLaborUnion(DycActIaborDO reqBO) {
        Long aLong = dycActlaborRepository.addActLaborUnionInfo(reqBO);
        if (null == aLong) {
            throw new ZTBusinessException("工会新增服务失败！");
        }
        reqBO.setLaborUnionId(aLong);
        return dycActlaborRepository.addListActLaborUnionRelaOrg(reqBO);
    }

    @Override
    public int modifyLaborUnion(DycActIaborDO reqBO) {
        //修改工会信息
        int i = dycActlaborRepository.updateActLaborUnionInfo(reqBO);
        //通过工会id删除机构关联信息
        dycActlaborRepository.deleteListActLaborUnionRelaOrg(reqBO);
        //批量新增工会与机构关联信息
        dycActlaborRepository.addListActLaborUnionRelaOrg(reqBO);
        return i;
    }

    @Override
    public int deleteLaborUnion(DycActIaborDO reqBO) {
        //TODO 校验工会是和存在活动中,如果存在，在看结算是否完成，才能修改

        //删除工会
        int i = dycActlaborRepository.deleteActLaborUnionInfo(reqBO);
        //通过工会id删除机构关联信息
        dycActlaborRepository.deleteListActLaborUnionRelaOrg(reqBO);
        return i;
    }

    @Override
    public BasePageRspBo<DycActLaborUnionInfo> queryLaborUnionPageList(DycActIaborDO reqBO) {
        return dycActlaborRepository.queryLaborUnionPageList(reqBO);
    }

    @Override
    public DycActLaborUnionInfo queryLaborUnionDetails(DycActIaborDO reqBO) {

        DycActLaborUnionInfo rspBO = dycActlaborRepository.queryActLaborUnionInfo(reqBO);

        DycActLaborUnionInfo laborUnionRelaOrg = dycActlaborRepository.queryListActLaborUnionRelaOrg(reqBO);

        rspBO.setRelaOrgList(laborUnionRelaOrg.getRelaOrgList());

        return rspBO;
    }

    @Override
    public List<DycActLaborUnionInfo> queryOrgBelongLaborUnion(DycActIaborDO reqBO) {
        List<DycActLaborUnionInfo> rspBO = new ArrayList<>();
        List<DycActLaborUnionInfo> unionInfos = dycActlaborRepository.queryOrgBelongLaborUnion(reqBO);
        if (!ObjectUtils.isEmpty(reqBO) && StringUtils.isNotEmpty(reqBO.getOrgIdWeb())) {
            unionInfos.forEach(item -> {
                if (reqBO.getOrgIdWeb().contains(String.valueOf(item.getOrgId()))) {
                    rspBO.add(item);
                }
            });
        }else {
            rspBO.addAll(unionInfos);
        }
        return rspBO;
    }
}
