package com.tydic.dyc.act.model.impl;

import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActAlertInfoRepository;
import com.tydic.dyc.act.repository.api.DycActOrderConsigneeInfoRepository;
import com.tydic.dyc.act.repository.api.DycActOrderInfoRepository;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName DycActOrderModeImpl
 * @Author 14051
 * @Date 2024/4/2 10:48
 * @Version 1.0
 * @Description TODO
 **/
@Slf4j
@Service
public class DycActOrderModeIImpl implements DycActOrderModel {

    @Autowired
    private DycActOrderInfoRepository dycActOrderInfoRepository;
    @Autowired
    private DycActAlertInfoRepository dycActAlertInfoRepository;

    @Autowired
    private DycActOrderConsigneeInfoRepository dycActOrderConsigneeInfoRepository;

    @Override
    public BasePageRspBo<DycActOrderInfo> qryOrdInfoPageList(DycActOrderQryDO dycActOrderQryDO) {
        return dycActOrderInfoRepository.qryOrdInfoPageList(dycActOrderQryDO);
    }

    @Override
    public BasePageRspBo<DycActOrderAfsInfo> qryOrdAfsInfoPageList(DycActOrderAfsQryDO dycActOrderAfsQryDO) {
        return dycActOrderInfoRepository.qryOrdAfsInfoPageList(dycActOrderAfsQryDO);
    }

    @Override
    public BigDecimal getTotalScoreByActivityId(Long activityId) {
        if (activityId == null){
            return BigDecimal.ZERO;
        }
        return dycActOrderInfoRepository.getTotalScoreByActivityId(activityId);
    }

    @Override
    public List<String> qryAlertOrderList(DycActDealAlertQryOrderDO reqBO) {
        return dycActOrderInfoRepository.qryAlertOrderList(reqBO);
    }

    @Override
    public void dealOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        //更新订单的预警
        dycActOrderInfoRepository.updateOrderAlertType(dycActDealOrderAlertDO);

        //写预警记录表
        dycActAlertInfoRepository.saveAlertInfo(dycActDealOrderAlertDO);
    }

    @Override
    public List<ActAlertOrderInfo> qryExistAlertOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return dycActOrderInfoRepository.qryExistAlertOrderList(dycActDealAlertQryOrderDO);
    }

    @Override
    public void dealUpdOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        //清空订单上的预警类型值
        dycActOrderInfoRepository.updateOrderAlertType(dycActDealOrderAlertDO);
        //更新预警记录表的状态为已处理
        dycActAlertInfoRepository.updateAlertInfo(dycActDealOrderAlertDO);
    }

    @Override
    public List<String> qryAlertAfsOrderList(DycActDealAlertQryOrderDO reqBO) {
        return dycActOrderInfoRepository.qryAlertAfsOrderList(reqBO);
    }

    @Override
    public void dealAfsOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        //更新服务单的预警
        dycActOrderInfoRepository.updateAfsOrderAlertType(dycActDealOrderAlertDO);

        //写服务单预警记录表
        dycActAlertInfoRepository.saveAlertInfo(dycActDealOrderAlertDO);
    }

    @Override
    public List<ActAlertAfsOrderInfo> qryExistAlertAfsOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return dycActOrderInfoRepository.qryExistAlertAfsOrderList(dycActDealAlertQryOrderDO);
    }

    @Override
    public void dealUpdAfsOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        //情况服务单上的预警类型值
        dycActOrderInfoRepository.updateAfsOrderAlertType(dycActDealOrderAlertDO);
        //更新预警记录表的状态为已处理
        dycActAlertInfoRepository.updateAlertInfo(dycActDealOrderAlertDO);
    }

    /**
     * 预警订单获取
     * @param dycActDealAlertQryOrderDO
     * @return
     */
    @Override
    public List<DycActOrderInfo> getWarnIngOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return dycActOrderInfoRepository.getWarnIngOrderList(dycActDealAlertQryOrderDO);
    }

    /**
     * 预警售后单列表获取
     * @param qryDO
     * @return
     */
    @Override
    public List<ActOrderAfterInfo> getOrderAfterWaring(DycActOrderAfsQryDO qryDO) {
        return dycActOrderInfoRepository.getOrderAfterWaring(qryDO);
    }

    @Override
    public String getUnFinishOrderId(DycActOrderQryDO reqBO) {
        return dycActOrderInfoRepository.getUnFinishOrderId(reqBO);
    }

    @Override
    public DycActOrderInfo queryOrderDetail(DycActOrderQryDO qryDO) {
        return dycActOrderInfoRepository.queryOrderDetail(qryDO);
    }

    @Override
    public List<ActOrderItemInfoDO> qryOrderItemInfoList(DycActOrderQryDO qryDO) {
        return dycActOrderInfoRepository.qryOrderItemInfoList(qryDO);
    }

    @Override
    public ActOrderConsigneeInfoBO qryOrderConsignee(DycActOrderQryDO qryDO) {
        ActOrderConsigneeInfoReqBO infoReqBO = new ActOrderConsigneeInfoReqBO();
        infoReqBO.setOrderId(qryDO.getOrderId());
        return dycActOrderConsigneeInfoRepository.queryActOrderConsigneeInfoSingle(infoReqBO).getData();
    }
}
