package com.tydic.dyc.act.model.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActProcessModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityChangeRepository;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.api.DycActivityFlowInstanceRepository;
import com.tydic.dyc.act.repository.api.DycActivityFlowTaskRepository;
import com.tydic.dyc.act.service.bo.DycActTaskBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 描述: 〈流程子域相关方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:17
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Service
public class DycActProcessModelImpl implements DycActProcessModel {
    @Autowired
    private DycActActivityRepository dycActActivityRepository;
    @Autowired
    private DycActActivityChangeRepository dycActActivityChangeRepository;
    @Autowired
    private DycActivityFlowInstanceRepository dycActivityFlowInstanceRepository;
    @Autowired
    private DycActivityFlowTaskRepository dycActivityFlowTaskRepository;

    @Override
    public BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO) {
        return dycActActivityRepository.queryActivityApprovePageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActActivityChangeApproveBaseInfo> queryActivityChangeApprovePageList(DycProcessDO reqBO) {
        return dycActActivityChangeRepository.queryActivityChangeApprovePageList(reqBO);
    }

    @Override
    public DycActivityFlowInstanceInfo dealTaskDeal(DycProcessDO reqBO) {

        //将完成任务更改状态
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            for (DycActTaskBO dycActTaskBO : reqBO.getCompleteTaskInfos()) {

                DycProcessDO processDO = new DycProcessDO();
                List<DycActivityFlowTaskInfo> flowTaskInfosList = new ArrayList<>();
                DycActivityFlowTaskInfo info = new DycActivityFlowTaskInfo();
                info.setTaskId(dycActTaskBO.getTaskId());
                info.setTaskStatus(dycActTaskBO.getDealResult() == 1 ? 2 : 3);
                info.setAuditUserId(Long.valueOf(dycActTaskBO.getCandidates().get(0).getCandidateId()));
                info.setAuditUserName(dycActTaskBO.getCandidates().get(0).getCandidateName());
                info.setAuditOrgId(dycActTaskBO.getCandidates().get(0).getOrgId());
                info.setAuditOrgName(dycActTaskBO.getCandidates().get(0).getOrgName());
                info.setAuditCompanyId(dycActTaskBO.getCandidates().get(0).getCompanyId());
                info.setAuditCompanyName(dycActTaskBO.getCandidates().get(0).getCompanyName());
                info.setAuditTime(new Date());
                if(dycActTaskBO.getDealResult() == 0) {
                    info.setRejectReason(reqBO.getCompleteTaskInfos().get(0).getDealRemark());
                }
                flowTaskInfosList.add(info);
                processDO.setFlowTaskInfosList(flowTaskInfosList);
                dycActivityFlowTaskRepository.updateActivityFlowTask(processDO);

                //将会签的人做处理
                if (null != dycActTaskBO.getAuditStepFinish() && dycActTaskBO.getAuditStepFinish()) {
                    DycProcessDO aDo = new DycProcessDO();
                    aDo.setTaskId(dycActTaskBO.getTaskId());
                    DycActivityFlowTaskInfo taskInfo = dycActivityFlowTaskRepository.queryActivityFlowTaskSingle(aDo);

                    DycProcessDO selectBO = new DycProcessDO();
                    selectBO.setFlowInstId(taskInfo.getFlowInstId());
                    selectBO.setCurrentNodeCode(taskInfo.getCurrentNodeCode());
                    selectBO.setTaskStatus(1);
                    List<DycActivityFlowTaskInfo> taskInfos = dycActivityFlowTaskRepository.queryActivityFlowTaskList(selectBO);
                    List<String> collect = taskInfos.stream().map(item -> {
                        return item.getTaskId();
                    }).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(collect)) {
                        DycProcessDO dycProcessDO = new DycProcessDO();
                        dycProcessDO.setTaskIds(collect);
                        dycActivityFlowTaskRepository.updateBatchTaskState(dycProcessDO);
                    }
                }
            }
        }

        //审批相关操作
        if (!CollectionUtils.isEmpty(reqBO.getNextTaskInfos()) && ObjectUtils.isEmpty(reqBO.getPreTaskId())) {
            //实例表的更新
            DycProcessDO updateReqBO = new DycProcessDO();
            List<DycActivityFlowInstanceInfo> list = new ArrayList<>();
            DycActivityFlowInstanceInfo instanceInfo = new DycActivityFlowInstanceInfo();
            instanceInfo.setCurrentNodeStatus(1);
            instanceInfo.setId(Long.valueOf(reqBO.getNextTaskInfos().get(0).getBusiObjId()));
            instanceInfo.setFlowKey(reqBO.getNextTaskInfos().get(0).getProcDefKey());
            instanceInfo.setFlowDefId(reqBO.getNextTaskInfos().get(0).getProcDefId());
            instanceInfo.setFlowInstId(reqBO.getNextTaskInfos().get(0).getProcInstId());
            instanceInfo.setCurrentNodeCode(reqBO.getNextTaskInfos().get(0).getStepId());
            instanceInfo.setCurrentNodeName(reqBO.getNextTaskInfos().get(0).getStepName());
            list.add(instanceInfo);
            updateReqBO.setFlowInstanceInfoList(list);
            dycActivityFlowInstanceRepository.updateActivityFlowInstance(updateReqBO);
            //任务表插入
            List<DycActivityFlowTaskInfo> collect = new ArrayList<>();
            reqBO.getNextTaskInfos().forEach(item -> {
                item.getCandidates().forEach(itemCandidate -> {
                    DycActivityFlowTaskInfo flowTaskInfo = new DycActivityFlowTaskInfo();
                    flowTaskInfo.setTaskId(item.getTaskId());
                    flowTaskInfo.setFlowInstId(item.getProcInstId());
                    flowTaskInfo.setCurrentNodeCode(item.getStepId());
                    flowTaskInfo.setCurrentNodeName(item.getStepName());
                    flowTaskInfo.setPendingAuditUserId(Long.valueOf(itemCandidate.getCandidateId()));
                    flowTaskInfo.setPendingAuditUserName(itemCandidate.getCandidateName());
                    flowTaskInfo.setPendingAuditOrgId(itemCandidate.getOrgId());
                    flowTaskInfo.setPendingAuditOrgName(itemCandidate.getOrgName());
                    flowTaskInfo.setPendingAuditCompanyId(itemCandidate.getCompanyId());
                    flowTaskInfo.setPendingAuditCompanyName(itemCandidate.getCompanyName());
                    collect.add(flowTaskInfo);
                });
            });
            updateReqBO.setFlowTaskInfosList(collect);
            dycActivityFlowTaskRepository.addListActivityFlowTask(updateReqBO);
            //对完成任务做更新
            if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
                DycProcessDO updateTaskReqBO = new DycProcessDO();
                List<DycActivityFlowTaskInfo> listTask = new ArrayList<>();
                DycActivityFlowTaskInfo updateTaskInfo = new DycActivityFlowTaskInfo();
                updateTaskInfo.setTaskId(reqBO.getCompleteTaskInfos().get(0).getTaskId());
                updateTaskInfo.setDelFlag(1);
                updateTaskInfo.setAuditTime(new Date());
                listTask.add(updateTaskInfo);
                updateTaskReqBO.setFlowTaskInfosList(listTask);
                dycActivityFlowTaskRepository.updateActivityFlowTask(updateReqBO);
            }
        }

        //前加签操作
        if (!ObjectUtils.isEmpty(reqBO.getPreTaskId()) && !CollectionUtils.isEmpty(reqBO.getNextTaskInfos())) {
            //将原任务删除
            DycProcessDO deleteReqBO = new DycProcessDO();
            deleteReqBO.setTaskId(reqBO.getPreTaskId());
            dycActivityFlowTaskRepository.deleteActivityFlowTask(deleteReqBO);
            //添加加签后的任务
            DycProcessDO insertReqBO = new DycProcessDO();
            List<DycActivityFlowTaskInfo> collect = new ArrayList<>();
            reqBO.getNextTaskInfos().forEach(item -> {
                item.getCandidates().forEach(itemCandidate -> {
                    DycActivityFlowTaskInfo flowTaskInfo = new DycActivityFlowTaskInfo();
                    flowTaskInfo.setTaskId(item.getTaskId());
                    flowTaskInfo.setFlowInstId(item.getProcInstId());
                    flowTaskInfo.setCurrentNodeCode(item.getStepId());
                    flowTaskInfo.setCurrentNodeName(item.getStepName());
                    flowTaskInfo.setAuditUserId(Long.valueOf(itemCandidate.getCandidateId()));
                    flowTaskInfo.setAuditUserName(itemCandidate.getCandidateName());
                    collect.add(flowTaskInfo);
                });
            });
            insertReqBO.setFlowTaskInfosList(collect);
            dycActivityFlowTaskRepository.addListActivityFlowTask(insertReqBO);
        }

        //转签操作
        if (!ObjectUtils.isEmpty(reqBO.getUpdateTaskCandidate()) && !CollectionUtils.isEmpty(reqBO.getUpdateTaskCandidate().getCandidates())) {
            DycProcessDO updateReqBO = new DycProcessDO();
            List<DycActivityFlowTaskInfo> flowTaskInfosList = new ArrayList<>();
            DycActivityFlowTaskInfo flowTaskInfo = new DycActivityFlowTaskInfo();
            flowTaskInfo.setTaskId(reqBO.getUpdateTaskCandidate().getTaskId());
            flowTaskInfo.setAuditUserId(Long.valueOf(reqBO.getUpdateTaskCandidate().getCandidates().get(0).getCandidateId()));
            flowTaskInfo.setAuditUserName(reqBO.getUpdateTaskCandidate().getCandidates().get(0).getCandidateName());
            flowTaskInfosList.add(flowTaskInfo);
            updateReqBO.setFlowTaskInfosList(flowTaskInfosList);
            dycActivityFlowTaskRepository.updateActivityFlowTask(updateReqBO);
        }

        return new DycActivityFlowInstanceInfo();
    }

    @Override
    public DycActivityFlowInstanceInfo dealTaskFinish(DycProcessDO reqBO) {
        DycProcessDO selectRepBO = new DycProcessDO();
        selectRepBO.setFlowInstId(reqBO.getProcInstId());
        DycActivityFlowInstanceInfo dycActivityFlowTaskInfo = dycActivityFlowInstanceRepository.queryActivityFlowInstanceSingle(selectRepBO);
        if (!ObjectUtils.isEmpty(dycActivityFlowTaskInfo)) {
            //修改实例表
            DycProcessDO updateRepBO = new DycProcessDO();
            List<DycActivityFlowInstanceInfo> flowInstanceInfoList = new ArrayList<>();
            DycActivityFlowInstanceInfo flowInstanceInfo = new DycActivityFlowInstanceInfo();
            flowInstanceInfo.setId(dycActivityFlowTaskInfo.getId());
            flowInstanceInfo.setIsFinish(0);
            flowInstanceInfo.setAuditEndTime(new Date());
            flowInstanceInfoList.add(flowInstanceInfo);
            updateRepBO.setFlowInstanceInfoList(flowInstanceInfoList);
            dycActivityFlowInstanceRepository.updateActivityFlowInstance(updateRepBO);
        }
        return new DycActivityFlowInstanceInfo();
    }

    @Override
    public DycActivityFlowInstanceInfo queryActivityFlowInstanceSingleTime(DycProcessDO reqBO) {
        return dycActivityFlowInstanceRepository.queryActivityFlowInstanceSingleTime(reqBO);
    }

    @Override
    public Long addActivityFlowInstance(DycProcessDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getFlowInstanceInfoList())) {
            throw new ZTBusinessException("审批实例不能为空！");
        }
        return dycActivityFlowInstanceRepository.addActivityFlowInstance(reqBO);
    }

    @Override
    public DycActivityFlowInstanceInfo queryActivityFlowInstanceSingle(DycProcessDO reqBO) {
        return dycActivityFlowInstanceRepository.queryActivityFlowInstanceSingle(reqBO);
    }
}
