package com.tydic.dyc.act.model.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 类名： DycActSkuInfoModelImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/4/8 17:07
 */
@Service
public class DycActSkuInfoModelImpl implements DycActSkuInfoModel {

    @Autowired
    private DycActSkuInfoRepository dycActSkuInfoRepository;

    @Autowired
    private DycActSkuGuideRepository dycActSkuGuideRepository;

    @Autowired
    private DycActSkuDetailRepository dycActSkuDetailRepository;

    @Autowired
    private DycActSkuSpecRepository dycActSkuSpecRepository;

    @Autowired
    private DycActSkuPicRepository dycActSkuPicRepository;

    @Override
    public ActSkuInfoQryRspBO querySkuPageList(ActSkuInfoQryBO qryBO) {
        return dycActSkuInfoRepository.querySkuPageList(qryBO);
    }

    @Override
    public ActSkuGuideListRspBO queryActSkuGuideList(ActSkuGuideReqBO actSkuGuideReqBO) {
        return dycActSkuGuideRepository.queryActSkuGuideList(actSkuGuideReqBO);
    }

    @Override
    public ActSkuGuideListRspBO getCatalogBOByCatalogIds(ActSkuGuideReqBO actSkuGuideReqBO) {
        return dycActSkuGuideRepository.getCatalogBOByCatalogIds(actSkuGuideReqBO);
    }

    @Override
    public ActSkuInfoRspBO querySkuDetails(ActSkuInfoReqBO qryBO) {
        ActSkuInfoRspBO skuInfoRspBO = dycActSkuInfoRepository.queryActSkuInfoSingle(qryBO);
        if (ObjectUtil.isNotEmpty(skuInfoRspBO.getData())) {
            ActSkuDetailReqBO detailReqBO = new ActSkuDetailReqBO();
            detailReqBO.setSkuId(skuInfoRspBO.getData().getSkuId());
            ActSkuDetailRspBO detailRspBO = dycActSkuDetailRepository.queryActSkuDetailSingle(detailReqBO);
            if (ObjectUtil.isNotEmpty(detailRspBO.getData())) {
                skuInfoRspBO.getData().setSkuPcDetailUrl(detailRspBO.getData().getSkuPcDetailUrl());
            }
        }
        return skuInfoRspBO;
    }

    @Override
    public ActSkuSpecListRspBO queryActSkuSpecList(ActSkuSpecReqBO actSkuSpecReqBO) {
        return dycActSkuSpecRepository.queryActSkuSpecList(actSkuSpecReqBO);
    }

    @Override
    public ActSkuPicListRspBO queryActSkuPicList(ActSkuPicReqBO actSkuPicReqBO) {
        return dycActSkuPicRepository.queryActSkuPicList(actSkuPicReqBO);
    }

    @Override
    public ActSkuInfoListRspBO queryActSkuInfoList(ActSkuInfoReqBO actSkuInfoReqBO) {
        return dycActSkuInfoRepository.queryActSkuInfoList(actSkuInfoReqBO);
    }

}
