package com.tydic.dyc.act.model.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.*;
import com.tydic.dyc.act.service.bo.DycActAddSkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActAddSkuPoolRspBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRspBO;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：DycActSkuPoolModelImpl
 * 说明：
 * 时间：2024/4/15 20:27
 * 作者：Zhouhaifeng
 */
@Service
public class DycActSkuPoolModelImpl implements DycActSkuPoolModel {

    @Autowired
    private DycActSkuPoolRepository dycActSkuPoolRepository;

    @Autowired
    private DycActRelSkuPoolRepository dycActRelSkuPoolRepository;

    @Autowired
    private DycActRelSourcePoolRepository dycActRelSourcePoolRepository;

    @Autowired
    private DycActSkuVendorRepository dycActSkuVendorRepository;

    @Autowired
    private DycActSkuGuideRepository dycActSkuGuideRepository;

    @Override
    public DycActQuerySkuPoolRspBO querySkuPoolDetail(DycActQuerySkuPoolReqBO reqBO) {
        return dycActSkuPoolRepository.queryActSkuPoolSingle(reqBO);
    }

    @Override
    public DycActAddSkuPoolRspBO addSkuPool(DycActAddSkuPoolReqBO reqBO) {
        ActSkuPoolRspBO actSkuPoolRspBO = dycActSkuPoolRepository.addActSkuPool(JUtil.js(reqBO, ActSkuPoolReqBO.class));
        return JUtil.js(actSkuPoolRspBO,DycActAddSkuPoolRspBO.class);
    }

    @Override
    public RspPage<ActSkuPoolBO> querySkuPoolPageList(ActSkuPoolReqBO actSkuPoolReqBO) {
        return dycActSkuPoolRepository.querySkuPoolPageList(actSkuPoolReqBO);
    }

    @Override
    public ActSkuPoolRspBO deleteActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        return dycActSkuPoolRepository.deleteActSkuPool(actSkuPoolReqBO);
    }

    @Override
    public ActSkuPoolRspBO modifySkuPool(ActSkuPoolReqBO reqBO) {
        return dycActSkuPoolRepository.updateActSkuPool(reqBO);
    }

    @Override
    public ActRelSkuPoolListRspBO batchInsertActRelSkuPool(List<ActRelSkuPoolReqBO> actRelSkuPoolReqBO) {
        return dycActRelSkuPoolRepository.addListActRelSkuPool(actRelSkuPoolReqBO);
    }

    @Override
    public ActRelSourcePoolListRspBO batchInsertActRelSourcePool(List<ActRelSourcePoolReqBO> actRelSourcePoolReqBO) {
        return dycActRelSourcePoolRepository.addListActRelSourcePool(actRelSourcePoolReqBO);
    }

    @Override
    public ActRelSkuPoolRspBO batchDeleteActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        return dycActRelSkuPoolRepository.deleteListActRelSkuPool(actRelSkuPoolReqBO);
    }

    @Override
    public ActRelSourcePoolRspBO batchDeleteActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        return dycActRelSourcePoolRepository.deleteListActRelSourcePool(actRelSourcePoolReqBO);
    }

    @Override
    public ActSkuPoolListRspBO queryActSkuPoolList(ActSkuPoolReqBO actSkuPoolReqBO) {
        return dycActSkuPoolRepository.queryActSkuPoolList(actSkuPoolReqBO);
    }

    @Override
    public RspPage<ActRelSourcePoolBO> querySkuPoolRelPageListBySup(ActRelSourcePoolReqBO sourcePoolReqBO) {
        if (!DycActivityConstants.PoolType.SUPPLIER.equals(sourcePoolReqBO.getPoolType())) {
            throw new ZTBusinessException("只能查询供应商类型的商品池");
        }
        RspPage<ActRelSourcePoolBO> rspPage = dycActRelSourcePoolRepository.queryActRelSourcePoolListPage(sourcePoolReqBO);
        if (rspPage.getRecordsTotal() > 0) {
            List<Long> sourceIds = rspPage.getRows().stream().map(ActRelSourcePoolBO::getSourceId).collect(Collectors.toList());
            // 获取商品数量Map
            Map<Long, Integer> skuNumBySource = getSkuNumMap(sourcePoolReqBO.getPoolType(), sourceIds,sourcePoolReqBO.getPoolId());

            // 获取供应商名称Map
            ActSkuVendorReqBO vendorReqBO = new ActSkuVendorReqBO();
            vendorReqBO.setVendorIdList(sourceIds);
            List<ActSkuVendorBO> data = dycActSkuVendorRepository.queryActSkuVendorList(vendorReqBO).getData();
            Map<Long, String> sourceNameBySource = new HashMap<>();
            if (!CollectionUtils.isEmpty(data)) {
                sourceNameBySource = data.stream().collect(Collectors.toMap(ActSkuVendorBO::getVendorId,ActSkuVendorBO::getVendorName));
            }

            // 遍历设置参数
            for (ActRelSourcePoolBO sourcePoolBO : rspPage.getRows()) {
                if (skuNumBySource.containsKey(sourcePoolBO.getSourceId())) {
                    sourcePoolBO.setSkuNum(skuNumBySource.get(sourcePoolBO.getSourceId()));
                }
                if (sourceNameBySource.containsKey(sourcePoolBO.getSourceId())) {
                    sourcePoolBO.setSourceName(sourceNameBySource.get(sourcePoolBO.getSourceId()));
                }
            }
        }
        return rspPage;
    }

    @Override
    public RspPage<ActRelSourcePoolBO> querySkuPoolRelPageListByCatalog(ActRelSourcePoolReqBO sourcePoolReqBO) {
        if (!DycActivityConstants.PoolType.CATALOG.equals(sourcePoolReqBO.getPoolType())) {
            throw new ZTBusinessException("只能查询商品类目类型的商品池");
        }
        RspPage<ActRelSourcePoolBO> rspPage = dycActRelSourcePoolRepository.queryActRelSourcePoolListPage(sourcePoolReqBO);
        if (rspPage.getRecordsTotal() > 0) {
            List<Long> sourceIds = rspPage.getRows().stream().map(ActRelSourcePoolBO::getSourceId).collect(Collectors.toList());
            // 获取商品数量Map
            Map<Long, Integer> skuNumBySource = getSkuNumMap(sourcePoolReqBO.getPoolType(), sourceIds,sourcePoolReqBO.getPoolId());

            // 获取类目全名称
            ActSkuGuideReqBO guideReqBO = new ActSkuGuideReqBO();
            guideReqBO.setGuideCatalogIdList(sourceIds);
            Map<Long, ActSkuGuideBO> catalogBOByCatalogIds = dycActSkuGuideRepository.getCatalogBOByCatalogIds(guideReqBO).getCatalogBOByCatalogIds();

            // 遍历设置参数
            for (ActRelSourcePoolBO sourcePoolBO : rspPage.getRows()) {
                if (skuNumBySource.containsKey(sourcePoolBO.getSourceId())) {
                    sourcePoolBO.setSkuNum(skuNumBySource.get(sourcePoolBO.getSourceId()));
                }
                if (catalogBOByCatalogIds.containsKey(sourcePoolBO.getSourceId())) {
                    sourcePoolBO.setSourceName(catalogBOByCatalogIds.get(sourcePoolBO.getSourceId()).getCatalogFullName());
                }
            }
        }
        return rspPage;
    }

    @Override
    public ActRelSourcePoolListRspBO queryActRelSourcePoolList(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        return dycActRelSourcePoolRepository.queryActRelSourcePoolList(actRelSourcePoolReqBO);
    }

    @Override
    public ActRelSkuPoolListRspBO queryActRelSkuPoolList(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        return dycActRelSkuPoolRepository.queryActRelSkuPoolList(actRelSkuPoolReqBO);
    }

    private Map<Long, Integer> getSkuNumMap(Integer poolType, List<Long> sourceIds,Long poolId) {
        // 获取商品数量Map
        ActRelSourcePoolReqBO poolReqBO = new ActRelSourcePoolReqBO();
        poolReqBO.setPoolId(poolId);
        poolReqBO.setPoolType(poolType);
        poolReqBO.setSourceIdList(sourceIds);
        return dycActRelSourcePoolRepository.getSkuNumBySource(poolReqBO);
    }
}
