package com.tydic.dyc.act.model.impl;

import com.tydic.dyc.act.model.api.DycActVendorModel;
import com.tydic.dyc.act.model.bo.ActSkuVendorListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorReqBO;
import com.tydic.dyc.act.repository.api.DycActSkuVendorRepository;
import com.tydic.dyc.act.service.bo.*;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题：DycActVendorModelImpl
 * 说明：
 * 时间：2024/4/10 16:29
 * 作者：Zhouhaifeng
 */
@Service
public class DycActVendorModelImpl implements DycActVendorModel {

    @Autowired
    private DycActSkuVendorRepository dycActSkuVendorRepository;

    @Override
    public DycActVendorDropRspBO queryVendorDrop(DycActVendorDropReqBO reqBO) {
        DycActVendorDropRspBO rspBO = new DycActVendorDropRspBO();
        ActSkuVendorReqBO actSkuVendorReqBO = new ActSkuVendorReqBO();
        actSkuVendorReqBO.setVendorId(reqBO.getVendorId());
        ActSkuVendorListRspBO actSkuVendorListRspBO = dycActSkuVendorRepository.queryActSkuVendorList(actSkuVendorReqBO);
        List<DycActVendorDropBO> vendorList = JUtil.jsl(actSkuVendorListRspBO.getData(),DycActVendorDropBO.class);
        rspBO.setVendorList(vendorList);
        return rspBO;
    }

    @Override
    public DycActQuerySkuPoolNotRelVendorPageListRspBO querySkuPoolNotRelVendorPageList(DycActQuerySkuPoolNotRelVendorPageListReqBO reqBO) {
        return dycActSkuVendorRepository.querySkuPoolNotRelVendorPageList(reqBO);
    }
}
