package com.tydic.dyc.act.model.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.*;
import com.tydic.dyc.act.service.bo.*;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 描述: 〈活动变更子域相关方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:15
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Service
public class DycActivityChangeModelImpl implements DycActivityChangeModel {

    @Autowired
    private DycActActivityChangeRepository dycActActivityChangeRepository;
    @Autowired
    private DycActFileRepository dycActFileRepository;
    @Autowired
    private DycActActivityChangeCommodityRepository dycActActivityChangeCommodityRepository;


    @Autowired
    private DycActSkuInfoRepository dycActSkuInfoRepository;

    @Autowired
    private DycActActivityRepository dycActActivityRepository;

    @Autowired
    private DycActActivitySupplierRepository dycActActivitySupplierRepository;


    @Autowired
    private DycActActivityChangeSupplierRepository dycActActivityChangeSupplierRepository;

    @Autowired
    private DycActActivityCommodityRepository dycActActivityCommodityRepository;

    @Autowired
    private DycActActivityUserRepository dycActActivityUserRepository;

    @Autowired
    private DycActActivityChangeUserRepository dycActActivityChangeUserRepository;

    @Autowired
    private ActActivityChangeUserScoresChangeRepository actActivityChangeUserScoresChangeRepository;

    @Autowired
    private DycActActivityChangeCommodityCatalogRepository dycActActivityChangeCommodityCatalogRepository;

    @Autowired
    private DycActActivityCommodityCatalogRepository dycActActivityCommodityCatalogRepository;

    @Override
    public DycActivityChangeRspDO queryActivityChangeBaseInfo(DycActivityChangeDO reqBo) {
        //初始化返回值
        DycActivityChangeRspDO rspBo = new DycActivityChangeRspDO();
        //变更单基本信息
        DycActivityChangeInfo changeInfo = dycActActivityChangeRepository.queryActivityChangeBaseInfo(reqBo);
        //变更单附件列表
        DycActivityDO dycActivityDo = new DycActivityDO();
        dycActivityDo.setObjId(reqBo.getChangeId());
        dycActivityDo.setObjType(2);
        List<DycActivityFileInfo> dycChangeFileInfos = dycActFileRepository.queryActivityFileList(dycActivityDo);
        //变更单活动附件列表
        DycActivityDO dycActivityFileDo = new DycActivityDO();
        dycActivityFileDo.setObjId(reqBo.getChangeId());
        dycActivityFileDo.setObjType(4);
        List<DycActivityFileInfo> dycChangeActivityFileInfos = dycActFileRepository.queryActivityFileList(dycActivityFileDo);
        //查询供应商信息
        DycActivityChangeSupplierInfo dycActivityChangeSupplierInfo = new DycActivityChangeSupplierInfo();
        dycActivityChangeSupplierInfo.setChangeId(reqBo.getChangeId());
        List<DycActivityChangeSupplierInfo> listNew = dycActActivityChangeSupplierRepository.getListNew(dycActivityChangeSupplierInfo);
        List<DycActivityChangeSupplierInfoBO> dycActivityChangeSupplierInfoBoList = JSONObject.parseArray(JSONObject.toJSONString(listNew), DycActivityChangeSupplierInfoBO.class);
        rspBo.setDycSaasActivityChangeSupplierInfoBoList(dycActivityChangeSupplierInfoBoList);
        rspBo.setChangeBaseDetail(changeInfo);
        rspBo.setChangeFileList(dycChangeFileInfos);
        rspBo.setChangeActivityFileList(dycChangeActivityFileInfos);
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public BasePageRspBo<DycActivityChangeSupplierInfo> queryActivityChangeSelectedSupplierPageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeSupplierRepository.queryActivityChangeSelectedSupplierPageList(reqBO);
    }

    @Override
    public int batchSelectActivityChangeSupplier(DycActivityChangeDO reqBO) {
        return dycActActivityChangeSupplierRepository.batchSelectActivityChangeSupplier(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeSupplier(DycActivityChangeDO reqBO) {
        return dycActActivityChangeSupplierRepository.batchRemoveActivityChangeSupplier(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> queryActivityChangeCommodityPoolPageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.queryActivityChangeCommodityPoolPageList(reqBO);
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchSelectActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityPool(reqBO);
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchRemoveActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodityPool(reqBO);
    }

    @Override
    public DycActivityChangeInfo changeActivity(DycActivityChangeDO reqBo) {
        //初始化返回值
        DycActivityChangeInfo rspBO = new DycActivityChangeInfo();
        //查询原始活动单对应的变更单
        List<DycActivityChangeInfo> list = getDycActivityChangeInfos(reqBo);
        //判断原始合同是否存在审批中或草稿态的变更单
        if (!CollectionUtils.isEmpty(list)) {
            //原始合同存在审批中的单据
            Map<String, List<DycActivityChangeInfo>> map = list.stream().collect(Collectors.groupingBy(DycActivityChangeInfo::getChangeState));
            if (map.containsKey(DycActivityConstants.ChangeState.CHANGE_STATE_ONE)) {
                throw new ZTBusinessException("该活动存在审批中的变更单");
            }
            //如果之前创建了变更草稿数据更新原始活动状态再返回
            if (map.containsKey(DycActivityConstants.ChangeState.CHANGE_STATE_ZERO)) {
                //查询原始活动单据获取当前状态
                DycActivityBaseInfo dycActivityDo = getDycActivityDo(reqBo);
                Long changeId = map.get(DycActivityConstants.ChangeState.CHANGE_STATE_ZERO).get(0).getChangeId();
                rspBO.setChangeId(changeId);
                //更新原始活动状态
                updateState(dycActivityDo, changeId);
                return rspBO;
            }
        }
        //查询原始活动信息
        DycActivityBaseInfo activityBaseInfo = getDycActivityBaseInfos(reqBo);
        //新增变更草稿主体信息
        Long changeId = setDycActivityChangeInfo(reqBo, activityBaseInfo);
        //新增变更草稿供应商信息
        extractedSupplier(changeId, reqBo);
        //新增变更草稿（商品池，商品类型，商品）信息
        setItem(reqBo, activityBaseInfo, changeId);
        //新增变更草稿用户信息
        extractedUser(reqBo, changeId);
        //新增变更附件信息
        extractedFile(changeId, reqBo);
        //新增后设置返回值供前端查询页面草稿信息
        rspBO.setChangeId(changeId);
        return rspBO;
    }

    /**
     * 查询原始活动单据获取当前状态
     *
     * @param reqBo
     * @return
     */
    private DycActivityBaseInfo getDycActivityDo(DycActivityChangeDO reqBo) {
        DycActivityBaseInfo dycActivityDo = new DycActivityBaseInfo();
        dycActivityDo.setActivityId(reqBo.getActivityId());
        dycActivityDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityBaseInfo dycActivityBaseInfo = dycActActivityRepository.getModelByNew(dycActivityDo);
        if (dycActivityBaseInfo == null) {
            throw new ZTBusinessException("未查询到原始活动单据！");
        }
        return dycActivityDo;
    }

    /**
     * 更新原始活动状态
     *
     * @param dycActivityDo
     * @param changeId
     */
    private void updateState(DycActivityBaseInfo dycActivityDo, Long changeId) {
        DycActivityChangeDO activityChangeDo = new DycActivityChangeDO();
        activityChangeDo.setChangeId(changeId);
        activityChangeDo.setOriginalActivityState(dycActivityDo.getActivityState());
        dycActActivityChangeRepository.updateByCondition(activityChangeDo);
    }

    /**
     * 新增变更草稿商品池，商品类型，商品
     *
     * @param reqBo
     * @param activityBaseInfo
     * @param changeId
     */
    private void setItem(DycActivityChangeDO reqBo, DycActivityBaseInfo activityBaseInfo, Long changeId) {
        switch (String.valueOf(activityBaseInfo.getCommodityRelaMethod())) {
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_ONE:
                extractedCommodityPool(reqBo, changeId);
                break;
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_TWO:
                extractedCatalog(reqBo, changeId);
                break;
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_THREE:
                extractedCommodity(reqBo, changeId);
                break;
            default:
                break;
        }
    }

    /**
     * 新增变更草稿主体信息
     *
     * @param reqBO
     * @param activityBaseInfo
     * @return
     */
    private Long setDycActivityChangeInfo(DycActivityChangeDO reqBO, DycActivityBaseInfo activityBaseInfo) {
        Long changeId = Sequence.getInstance().nextId();
        DycActivityChangeInfo activityChangeDo = JSON.parseObject(JSON.toJSONString(activityBaseInfo), DycActivityChangeInfo.class);
        activityChangeDo.setCreateUserId(reqBO.getCreateUserId());
        activityChangeDo.setCreateUserName(reqBO.getCreateUserName());
        activityChangeDo.setOriginalActivityId(activityBaseInfo.getActivityId());
        activityChangeDo.setOriginalActivityCode(activityBaseInfo.getActivityCode());
        activityChangeDo.setOriginalActivityVersion(activityBaseInfo.getActivityVersion());
        activityChangeDo.setNewActivityVersion(activityBaseInfo.getActivityVersion() + 1);
        activityChangeDo.setNewActivityCode(activityBaseInfo.getActivityCode());
        activityChangeDo.setOriginalActivityState(activityBaseInfo.getActivityState());
        activityChangeDo.setUpdateTime(null);
        activityChangeDo.setUpdateUserId(null);
        activityChangeDo.setUpdateUserName("");
        activityChangeDo.setChangeId(changeId);
        // 获取当前时间
        LocalDateTime now = LocalDateTime.now();
        // 格式化当前时间
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDateTime = now.format(formatter);
        // 生成3位随机数字
        Random random = new Random();
        int randomNum = random.nextInt(900) + 100;
        // 组合字符串
        String changeCode = "HDBGD" + formattedDateTime + randomNum;
        activityChangeDo.setChangeCode(changeCode);
        activityChangeDo.setChangeState(String.valueOf(0));
        activityChangeDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        activityChangeDo.setCreateTime(new Date());
        dycActActivityChangeRepository.insertNew(activityChangeDo);
        return changeId;
    }

    /**
     * 查询原始活动信息
     *
     * @param reqBO
     * @return
     */
    private DycActivityBaseInfo getDycActivityBaseInfos(DycActivityChangeDO reqBO) {
        DycActivityBaseInfo activityDo = new DycActivityBaseInfo();
        activityDo.setActivityId(reqBO.getActivityId());
        activityDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityBaseInfo activityBaseInfos = dycActActivityRepository.getModelByNew(activityDo);
        if (activityBaseInfos == null) {
            throw new ZTBusinessException("查询原始活动单据为空！");
        }
        return activityBaseInfos;
    }

    /**
     * 查询原始活动单对应的变更单
     *
     * @param reqBO
     * @return
     */
    private List<DycActivityChangeInfo> getDycActivityChangeInfos(DycActivityChangeDO reqBO) {
        DycActivityChangeInfo dycActivityChangeInfo = new DycActivityChangeInfo();
        dycActivityChangeInfo.setOriginalActivityId(reqBO.getActivityId());
        dycActivityChangeInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        return dycActActivityChangeRepository.getListNew(dycActivityChangeInfo);
    }


    /**
     * 新增变更附件信息
     *
     * @param changeId
     */
    public void extractedFile(Long changeId, DycActivityChangeDO reqBo) {
        DycActivityDO dycActivityDo = new DycActivityDO();
        dycActivityDo.setObjId(reqBo.getActivityId());
        List<DycActivityFileInfo> fileInfos = dycActFileRepository.queryActivityFileList(dycActivityDo);
        if (!CollectionUtils.isEmpty(fileInfos)) {
            List<DycActivityFileInfo> collect = fileInfos.stream().map(item -> {
                DycActivityFileInfo fileInfo = new DycActivityFileInfo();
                BeanUtils.copyProperties(item, fileInfo);
                fileInfo.setObjId(changeId);
                fileInfo.setObjType(4);
                fileInfo.setDelFlag(0);
                return fileInfo;
            }).collect(Collectors.toList());
            dycActFileRepository.addListActivityFileInfo(collect);
        }
    }

    /**
     * 新增变更草稿供应商信息
     *
     * @param changeId
     * @param reqBo
     */
    public void extractedSupplier(Long changeId, DycActivityChangeDO reqBo) {
        DycActivitySupplierInfo activityDo = new DycActivitySupplierInfo();
        activityDo.setActivityId(reqBo.getActivityId());
        List<DycActivitySupplierInfo> supplierInfos = dycActActivitySupplierRepository.getListNew(activityDo);
        if (!CollectionUtils.isEmpty(supplierInfos)) {
            List<DycActivityChangeSupplierInfo> dycActivityChangeSupplierInfos = JSONObject.parseArray(JSONObject.toJSONString(supplierInfos), DycActivityChangeSupplierInfo.class);
            dycActivityChangeSupplierInfos.forEach(o -> {
                o.setChangeId(changeId);
                o.setId(Sequence.getInstance().nextId());
            });
            dycActActivityChangeSupplierRepository.insertBatchNew(dycActivityChangeSupplierInfos);
        }
    }


    /**
     * 新增变更草稿用户信息
     *
     * @param reqBo
     * @param changeId
     */
    public void extractedUser(DycActivityChangeDO reqBo, Long changeId) {
        //用户
        DycActivityUserInfo activityDo = new DycActivityUserInfo();
        activityDo.setActivityId(reqBo.getActivityId());
        activityDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<DycActivityUserInfo> userInfos = dycActActivityUserRepository.getListNew(activityDo);
        if (!CollectionUtils.isEmpty(userInfos)) {
            List<DycActivityChangeUserInfo> dycActivityChangeUserInfos = JSONObject.parseArray(JSONObject.toJSONString(userInfos), DycActivityChangeUserInfo.class);
            dycActivityChangeUserInfos.forEach(item -> {
                item.setId(Sequence.getInstance().nextId());
                item.setChangeId(changeId);
                item.setCreateTime(new Date());
                item.setCreateUserId(reqBo.getUserId());
                item.setCreateUserName(reqBo.getName());
                item.setUpdateTime(null);
                item.setUpdateUserId(null);
                item.setUpdateUserName(null);
                item.setOriginalScores(item.getGiveScores());
            });
            dycActActivityChangeUserRepository.insertBatchNew(dycActivityChangeUserInfos);
        }
    }

    /**
     * 新增变更草稿商品类目信息
     *
     * @param reqBo
     * @param changeId
     */
    public void extractedCatalog(DycActivityChangeDO reqBo, Long changeId) {
        //商品类型
        DycActiveCommodityCatalogInfo commodityCatalogInfo = new DycActiveCommodityCatalogInfo();
        commodityCatalogInfo.setActivityId(reqBo.getActivityId());
        commodityCatalogInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<DycActiveCommodityCatalogInfo> catalogInfoList = dycActActivityCommodityCatalogRepository.getListNew(commodityCatalogInfo);
        if (!CollectionUtils.isEmpty(catalogInfoList)) {
            List<DycActivityChangeRelaCommodityCatalogInfo> dycActivityChangeRelaCommodityInfos = JSONObject.parseArray(JSONObject.toJSONString(catalogInfoList), DycActivityChangeRelaCommodityCatalogInfo.class);
            dycActivityChangeRelaCommodityInfos.forEach(o -> {
                o.setCreateUserId(reqBo.getUserId());
                o.setCreateUserName(reqBo.getName());
                o.setCreateTime(new Date());
                o.setRelaId(Sequence.getInstance().nextId());
                o.setChangeId(changeId);
                o.setUpdateTime(null);
                o.setUpdateUserId(null);
                o.setUpdateUserName(null);
            });
            dycActActivityChangeCommodityCatalogRepository.insertBatchNew(dycActivityChangeRelaCommodityInfos);
        }
    }


    /**
     * 新增变更草稿商品信息
     *
     * @param reqBo
     * @param changeId
     */
    public void extractedCommodity(DycActivityChangeDO reqBo, Long changeId) {
        //商品
        DycActActivityRelaCommodityInfo activityDo = new DycActActivityRelaCommodityInfo();
        activityDo.setActivityId(reqBo.getActivityId());
        activityDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<DycActActivityRelaCommodityInfo> relaCommodityInfos = dycActActivityCommodityRepository.getListNew(activityDo);
        if (!CollectionUtils.isEmpty(relaCommodityInfos)) {
            List<DycActivityChangeRelaCommodityInfo> dycActivityChangeRelaCommodityInfos = JSONObject.parseArray(JSONObject.toJSONString(relaCommodityInfos), DycActivityChangeRelaCommodityInfo.class);
            dycActivityChangeRelaCommodityInfos.forEach(item -> {
                item.setRelaId(Sequence.getInstance().nextId());
                item.setChangeId(changeId);
                item.setCreateTime(new Date());
                item.setCreateUserId(reqBo.getUserId());
                item.setCreateUserName(reqBo.getName());
                item.setUpdateTime(null);
                item.setUpdateUserId(null);
                item.setUpdateUserName(null);
            });
            dycActActivityChangeCommodityRepository.insertBatchNew(dycActivityChangeRelaCommodityInfos);
        }
    }


    /**
     * 新增变更草稿商品池信息
     *
     * @param reqBo
     * @param changeId
     */
    public void extractedCommodityPool(DycActivityChangeDO reqBo, Long changeId) {
        //商品池
        DycQueryActivityCommodityPoolPageListReqBO listReqBo = new DycQueryActivityCommodityPoolPageListReqBO();
        listReqBo.setActivityId(reqBo.getActivityId());
        List<DycActivityCommodityPoolInfo> commodityPoolInfos = dycActActivityCommodityRepository.queryActivityCommodityPoolList(listReqBo);
        if (!CollectionUtils.isEmpty(commodityPoolInfos)) {
            DycActivityChangeDO changeDo = new DycActivityChangeDO();
            changeDo.setChangeId(changeId);
            changeDo.setCreateUserId(reqBo.getCreateUserId());
            changeDo.setCreateUserName(reqBo.getCreateUserName());
            List<DycActivityChangeRelaCommodityPoolInfo> collect = commodityPoolInfos.stream().map(item -> {
                DycActivityChangeRelaCommodityPoolInfo relaCommodityPoolInfo = new DycActivityChangeRelaCommodityPoolInfo();
                relaCommodityPoolInfo.setCommodityPoolId(item.getCommodityPoolId());
                relaCommodityPoolInfo.setCommodityPoolName(item.getCommodityPoolName());
                relaCommodityPoolInfo.setApplyActivityType(item.getApplyActivityType());
                relaCommodityPoolInfo.setRelaCommodityAmount(item.getRelaCommodityAmount());
                relaCommodityPoolInfo.setRelaCatalogAmount(item.getRelaCatalogAmount());
                return relaCommodityPoolInfo;
            }).collect(Collectors.toList());
            changeDo.setCommodityPoolList(collect);
            dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityPool(changeDo);
        }
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> queryActivityChangeSelectedCommodityCatalogPageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.queryActivityChangeSelectedCommodityCatalogPageList(reqBO);
    }

    @Override
    public int batchSelectActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityCatalog(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodityCatalog(reqBO);
    }

    @Override
    public BasePageRspBo<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(ActActivityChangeCommodityInfoQryDO qryDO) {
        return dycActActivityChangeCommodityRepository.queryActivityChangeCommodityPageList(qryDO);
    }

    @Override
    public List<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityList(ActActivityChangeCommodityInfoQryDO qryDO) {
        return dycActActivityChangeCommodityRepository.getList(ActRu.js(qryDO,ActivityChangeRelaCommodityInfo.class));
    }

    @Override
    public void batchSelectActivityChangeUser(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty(reqBo)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBo.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBo.getUserList())) {
            throw new ZTBusinessException("入参用户列表不能为空！");
        }
        dycActActivityChangeUserRepository.batchSelectActivityChangeUser(reqBo);
        List<String> collect = reqBo.getUserList().stream().map(DycActivityChangeUserInfo::getActUserName).collect(Collectors.toList());
        //更新用户积分操作表记录
        updateChange(collect, ActConstants.ChangeType.ADD, reqBo.getChangeId());
    }

    @Override
    public void batchRemoveActivityChangeUser(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty(reqBo)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBo.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBo.getUserIdList())) {
            throw new ZTBusinessException("用户列表不能为空！");
        }
        //更新用户数据为已删除
        dycActActivityChangeUserRepository.batchRemoveActivityChangeUser(reqBo);
        //查询用户集合信息
        List<String> collect = getUserName(reqBo.getUserIdList(),reqBo.getChangeId());
        //更新用户积分操作表记录
        updateChange(collect, ActConstants.ChangeType.DEL, reqBo.getChangeId());
    }

    /**
     * 查询用户集合信息
     * @param userIdList,changeId
     * @return
     */
    private List<String> getUserName(List<Long> userIdList,Long changeId) {
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setUserIdList(userIdList);
        dycActivityChangeDo.setChangeId(changeId);
        List<ActivityChangeUserInfo> activityChangeUserInfos = dycActActivityChangeUserRepository.queryChangeActivityUserListAll(dycActivityChangeDo);
        return activityChangeUserInfos.stream().map(ActivityChangeUserInfo::getUserName).collect(Collectors.toList());
    }

    /**
     * 更新用户积分操作表记录
     *
     * @param userNameList,changeType,
     */
    private void updateChange(List<String> userNameList, Integer changeType, Long changeId) {
        //查询用户积分表数据
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setUserNameList(userNameList);
        dycActivityChangeDo.setChangeId(changeId);
        List<ActivityChangeUserInfo> activityChangeUserInfos = dycActActivityChangeUserRepository.queryChangeActivityUserListAll(dycActivityChangeDo);
        List<Long> collectUserIdList = activityChangeUserInfos.stream().map(ActivityChangeUserInfo::getUserId).collect(Collectors.toList());
        //判断是否在用户积分变更记录表中有数据，如果有则跟新，如果没有则新增
        ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo = new ActActivityChangeUserScoresChangeDO();
        actActivityChangeUserScoresChangeDo.setUserIdList(collectUserIdList);
        actActivityChangeUserScoresChangeDo.setChangeId(changeId);
        List<ActActivityChangeUserScoresChangeDO> list = actActivityChangeUserScoresChangeRepository.getList(actActivityChangeUserScoresChangeDo);
        List<ActActivityChangeUserScoresChangeDO> actActivityChangeUserScoresChangeDoInsert = new ArrayList<>();
        if (CollectionUtils.isEmpty(list)) {
            activityChangeUserInfos.forEach(o -> {
                ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDoInsertModel = new ActActivityChangeUserScoresChangeDO();
                actActivityChangeUserScoresChangeDoInsertModel.setId(Sequence.getInstance().nextId());
                actActivityChangeUserScoresChangeDoInsertModel.setUserId(o.getUserId());
                actActivityChangeUserScoresChangeDoInsertModel.setChangeId(o.getChangeId());
                actActivityChangeUserScoresChangeDoInsertModel.setChangeType(changeType);
                if (ActConstants.DelFlag.DEL.equals(o.getDelFlag())) {
                    actActivityChangeUserScoresChangeDoInsertModel.setAfterChangeScores(BigDecimal.ZERO);
                } else {
                    actActivityChangeUserScoresChangeDoInsertModel.setAfterChangeScores(o.getGiveScores());
                }
                actActivityChangeUserScoresChangeDoInsertModel.setOriginalScores(o.getOriginalScores());
                actActivityChangeUserScoresChangeDoInsert.add(actActivityChangeUserScoresChangeDoInsertModel);
            });
        } else {
            Map<Long, ActActivityChangeUserScoresChangeDO> collect = list.stream().collect(Collectors.toMap(ActActivityChangeUserScoresChangeDO::getUserId, o -> o));
            activityChangeUserInfos.forEach(o -> {
                if (collect.get(o.getUserId()) != null) {
                    ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDoUpdateModelWhere = new ActActivityChangeUserScoresChangeDO();
                    actActivityChangeUserScoresChangeDoUpdateModelWhere.setId(collect.get(o.getUserId()).getId());
                    ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDoUpdateModelSet = new ActActivityChangeUserScoresChangeDO();
                    if (ActConstants.DelFlag.DEL.equals(o.getDelFlag())) {
                        actActivityChangeUserScoresChangeDoUpdateModelSet.setAfterChangeScores(BigDecimal.ZERO);
                    } else {
                        actActivityChangeUserScoresChangeDoUpdateModelSet.setAfterChangeScores(o.getGiveScores());
                    }
                    actActivityChangeUserScoresChangeDoUpdateModelSet.setChangeType(changeType);
                    actActivityChangeUserScoresChangeRepository.updateBy(actActivityChangeUserScoresChangeDoUpdateModelSet, actActivityChangeUserScoresChangeDoUpdateModelWhere);
                } else {
                    ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDoInsertModel = new ActActivityChangeUserScoresChangeDO();
                    actActivityChangeUserScoresChangeDoInsertModel.setId(Sequence.getInstance().nextId());
                    actActivityChangeUserScoresChangeDoInsertModel.setUserId(o.getUserId());
                    actActivityChangeUserScoresChangeDoInsertModel.setChangeId(o.getChangeId());
                    actActivityChangeUserScoresChangeDoInsertModel.setChangeType(changeType);
                    if (ActConstants.DelFlag.DEL.equals(o.getDelFlag())) {
                        actActivityChangeUserScoresChangeDoInsertModel.setAfterChangeScores(BigDecimal.ZERO);
                    } else {
                        actActivityChangeUserScoresChangeDoInsertModel.setAfterChangeScores(o.getGiveScores());
                    }
                    actActivityChangeUserScoresChangeDoInsertModel.setOriginalScores(o.getOriginalScores());
                    actActivityChangeUserScoresChangeDoInsert.add(actActivityChangeUserScoresChangeDoInsertModel);
                }
            });
        }
        if (!CollectionUtils.isEmpty(actActivityChangeUserScoresChangeDoInsert)) {
            actActivityChangeUserScoresChangeRepository.insertBatch(actActivityChangeUserScoresChangeDoInsert);
        }
    }

    @Override
    public int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodity(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodity(reqBO);
    }

    /**
     * 组装活动变更用户信息
     *
     * @param changeUserInfo
     * @return
     */
    private DycActivityChangeUserInfo getChangeUserInfo(ActivityChangeUserInfo changeUserInfo) {
        DycActivityChangeUserInfo dycActivityChangeUserInfo = ActRu.js(changeUserInfo, DycActivityChangeUserInfo.class);
        dycActivityChangeUserInfo.setActUserId(changeUserInfo.getUserId());
        dycActivityChangeUserInfo.setActUserName(changeUserInfo.getUserName());
        dycActivityChangeUserInfo.setActUserOrgId(changeUserInfo.getUserOrgId());
        dycActivityChangeUserInfo.setActUserCompanyId(changeUserInfo.getUserCompanyId());
        dycActivityChangeUserInfo.setActUserCompanyName(changeUserInfo.getUserCompanyName());
        dycActivityChangeUserInfo.setActName(changeUserInfo.getName());
        dycActivityChangeUserInfo.setActUserOrgName(changeUserInfo.getUserOrgName());
        dycActivityChangeUserInfo.setActWorkNo(changeUserInfo.getWorkNo());
        dycActivityChangeUserInfo.setActUserOrgPath(changeUserInfo.getUserOrgPath());
        return dycActivityChangeUserInfo;
    }

    @Override
    public DycActImportActivityChangeUserModelRspBO importActivityChangeUser(DycActImportActivityChangeUserModelReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getUserInfoList())) {
            throw new ZTBusinessException("没有需要增加的用户");
        }
        //得到变更id、操作人id、操作人名称
        Long changeId = reqBO.getChangeId();
        Long userId = reqBO.getUserId();
        String name = reqBO.getName();
        if (changeId == null || userId == null || !StringUtils.hasText(name)) {
            throw new ZTBusinessException("入参为空");
        }
        DycActivityChangeInfo dycActivityChangeInfo = new DycActivityChangeInfo();
        dycActivityChangeInfo.setChangeId(changeId);
        dycActivityChangeInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityChangeInfo modelByNew = dycActActivityChangeRepository.getModelByNew(dycActivityChangeInfo);
        if(modelByNew == null || modelByNew.getChangeId() == null){
            throw new ZTBusinessException("该变更不存在");
        }
        DycActImportActivityChangeUserModelRspBO rsp = new DycActImportActivityChangeUserModelRspBO();
        //得到活动id
//        DycActivityChangeDO changeInfo = new DycActivityChangeDO();
//        changeInfo.setChangeId(changeId);
//        DycActivityChangeInfo info = dycActActivityChangeRepository.queryActivityChangeBaseInfo(changeInfo);
//        Long activityId = info.getOriginalActivityId();

        //得到活动用户
//        DycActivityDO dycActivityDO = new DycActivityDO();
//        dycActivityDO.setActivityId(activityId);
//        List<DycActivityUserInfo> dycActivityUserInfos = dycActActivityUserRepository.queryActivityUserList(dycActivityDO);

        List<DycActImportActivityInfoBO> failReasonList = new ArrayList<>(reqBO.getUserInfoList().size());
//        List<ActivityChangeUserInfo> addChangeList = new ArrayList<>();
        //判断用户是否存在
//        if (!CollectionUtils.isEmpty(dycActivityUserInfos)) {
//            Map<Long, DycActivityUserInfo> userInfoMap = dycActivityUserInfos.stream().collect(Collectors.toMap(DycActivityUserInfo::getActUserId, v -> v));
//            for (ActivityChangeUserInfo changeUserInfo : reqBO.getUserInfoList()) {
//                if (userInfoMap.containsKey(changeUserInfo.getUserId())) {
//                    DycActImportActivityInfoBO dycActImportActivityInfoBO = new DycActImportActivityInfoBO();
//                    dycActImportActivityInfoBO.setFailReason("用户已存在于活动中");
//                    dycActImportActivityInfoBO.setLineNum(changeUserInfo.getGluttonLineNum());
//                    failReasonList.add(dycActImportActivityInfoBO);
//                } else {
//                    changeUserInfo.setOriginalScores(null);
//                    changeUserInfo.setBalanceScores(changeUserInfo.getGiveScores());
//                    changeUserInfo.setUsedScores(BigDecimal.ZERO);
//                    addChangeList.add(changeUserInfo);
//                }
//            }
//        }
//        if(CollectionUtils.isEmpty(addChangeList)){
//            rsp.setFailReasonList(failReasonList);
//            return rsp;
//        }
        //得到活动变更用户
        DycActivityChangeUserInfo dycActivityChangeDO = new DycActivityChangeUserInfo();
        dycActivityChangeDO.setChangeId(changeId);
        List<DycActivityChangeUserInfo> dycActivityChangeUserInfos = dycActActivityChangeUserRepository.getListNew(dycActivityChangeDO);
        List<DycActivityChangeUserInfo> addList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dycActivityChangeUserInfos)) {
            Map<String, DycActivityChangeUserInfo> changeUserInfoMap = dycActivityChangeUserInfos.stream().collect(Collectors.toMap(DycActivityChangeUserInfo::getUserName, v -> v));
            for (ActivityChangeUserInfo changeUserInfo : reqBO.getUserInfoList()) {
                if (changeUserInfoMap.containsKey(changeUserInfo.getUserName())) {
                    //存在更新
                    DycActivityChangeUserInfo dycActivityChangeUserInfo = getChangeUserInfo(changeUserInfo);
                    DycActivityChangeUserInfo changeUser = changeUserInfoMap.get(changeUserInfo.getUserName());
                    if (ActConstants.DelFlag.NOT_DEL.equals(changeUser.getDelFlag())) {
                        DycActImportActivityInfoBO dycActImportActivityInfoBO = new DycActImportActivityInfoBO();
                        dycActImportActivityInfoBO.setFailReason("用户已存在");
                        dycActImportActivityInfoBO.setLineNum(changeUserInfo.getGluttonLineNum());
                        failReasonList.add(dycActImportActivityInfoBO);
                        continue;
                    }
                    addList.add(dycActivityChangeUserInfo);
//                    dycActivityChangeUserInfo.setId(changeUser.getId());
//                    dycActivityChangeUserInfo.setUpdateUserId(userId);
//                    dycActivityChangeUserInfo.setUpdateUserName(name);
//                    dycActivityChangeUserInfo.setUpdateTime(new Date());
//                    dycActivityChangeUserInfo.setCreateUserId(null);
//                    dycActivityChangeUserInfo.setCreateUserName(null);
//                    dycActivityChangeUserInfo.setCreateTime(null);
//                    dycActActivityChangeUserRepository.update(dycActivityChangeUserInfo);
                } else {
                    //不存在新增
                    DycActivityChangeUserInfo dycActivityChangeUserInfo = getChangeUserInfo(changeUserInfo);
                    addList.add(dycActivityChangeUserInfo);
                }
            }
        } else {
            //不存在新增
            for (ActivityChangeUserInfo changeUserInfo : reqBO.getUserInfoList()) {
                DycActivityChangeUserInfo dycActivityChangeUserInfo = getChangeUserInfo(changeUserInfo);
                addList.add(dycActivityChangeUserInfo);
            }
        }
        if (!CollectionUtils.isEmpty(addList)) {
            DycActivityChangeDO add = new DycActivityChangeDO();
            add.setChangeId(reqBO.getChangeId());
            add.setUserList(addList);
            add.setCreateUserId(reqBO.getUserId());
            add.setCreateUserName(reqBO.getName());
            dycActActivityChangeUserRepository.batchSelectActivityChangeUser(add);
            //更新用户积分操作表记录
            List<String> collect = addList.stream().map(DycActivityChangeUserInfo::getUserName).collect(Collectors.toList());
            updateChange(collect, ActConstants.ChangeType.ADD, reqBO.getChangeId());
        }
        DycActivityChangeInfo set = new DycActivityChangeInfo();
        set.setUpdateTime(new Date());
        set.setUpdateUserId(userId);
        set.setUpdateUserName(name);
        DycActivityChangeInfo where = new DycActivityChangeInfo();
        where.setChangeId(changeId);
        dycActActivityChangeRepository.updateByNew(set, where);
        rsp.setFailReasonList(failReasonList);
        return rsp;
    }

    @Override
    public DycActImportActivityChangeCommodityModelRspBO importActivityChangeCommodity(DycActImportActivityChangeCommodityModelReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityItem())) {
            throw new ZTBusinessException("没有需要增加的商品");
        }

        //得到变更id、操作人id、操作人名称
        Long changeId = reqBO.getChangeId();
        Long userId = reqBO.getUserId();
        String name = reqBO.getName();
        if (changeId == null || userId == null || !StringUtils.hasText(name)) {
            throw new ZTBusinessException("入参为空");
        }
        DycActivityChangeInfo dycActivityChangeInfo = new DycActivityChangeInfo();
        dycActivityChangeInfo.setChangeId(changeId);
        dycActivityChangeInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityChangeInfo modelByNew = dycActActivityChangeRepository.getModelByNew(dycActivityChangeInfo);
        if(modelByNew == null || modelByNew.getChangeId() == null){
            throw new ZTBusinessException("该变更不存在");
        }
        //去重
        reqBO.setCommodityItem(reqBO.getCommodityItem().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(ActivityImportChangeCommodityInfo::getSkuCode))), ArrayList::new)));
        List<DycActImportActivityInfoModelBO> failList = new ArrayList<>();
        DycActImportActivityChangeCommodityModelRspBO rspBO = new DycActImportActivityChangeCommodityModelRspBO();
        DycActImportActivityCommodityModelBO dycActImportActivityCommodityModelBO = new DycActImportActivityCommodityModelBO();
        List<String> skuCodes = reqBO.getCommodityItem().stream().map(ActivityImportChangeCommodityInfo::getSkuCode).filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuCodes)) {
            for (ActivityImportChangeCommodityInfo info : reqBO.getCommodityItem()) {
                DycActImportActivityInfoModelBO dycActImportActivityInfoModelBO = new DycActImportActivityInfoModelBO();
                dycActImportActivityInfoModelBO.setLineNum(info.getGluttonLineNum());
                dycActImportActivityInfoModelBO.setFailReason("商品编码必填");
                failList.add(dycActImportActivityInfoModelBO);
            }
            rspBO.setFailReasonList(failList);
            return rspBO;
        }

        //获取变更单已选商品
        ActivityChangeRelaCommodityInfo info = new ActivityChangeRelaCommodityInfo();
        info.setChangeId(changeId);
        List<ActivityChangeRelaCommodityInfo> list = dycActActivityChangeCommodityRepository.getList(info);
        List<String> collect = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            collect = list.stream().map(ActivityChangeRelaCommodityInfo::getSkuCode).collect(Collectors.toList());
        }

        //根据skuCode获取活动商品
        Map<String, ActSkuInfoBO> infoBOMap = dycActSkuInfoRepository.queryActSkuInfoByCodeList(new ArrayList<>(skuCodes));


        List<DycActivityChangeRelaCommodityInfo> addList = new ArrayList<>();
        boolean check = false;
        for (ActivityImportChangeCommodityInfo importChangeCommodityInfo : reqBO.getCommodityItem()) {
            //商品信息
            ActSkuInfoBO skuInfoBO = infoBOMap.get(importChangeCommodityInfo.getSkuCode());
            Boolean checkSku = checkSku(failList, importChangeCommodityInfo, skuInfoBO);
            //校验商品
            if (checkSku) {
                continue;
            }
            DycActivityChangeRelaCommodityInfo dycActivityChangeRelaCommodityInfo = setCommodityInfo(skuInfoBO);

            if (!CollectionUtils.isEmpty(collect) && collect.contains(importChangeCommodityInfo.getSkuCode())) {
                //存在更新
                dycActivityChangeRelaCommodityInfo.setChangeId(changeId);
                dycActivityChangeRelaCommodityInfo.setUpdateTime(new Date());
                dycActivityChangeRelaCommodityInfo.setUpdateUserId(userId);
                dycActivityChangeRelaCommodityInfo.setUpdateUserName(name);
                ActivityChangeRelaCommodityInfo activityChangeRelaCommodityInfo = ActRu.js(dycActivityChangeRelaCommodityInfo, ActivityChangeRelaCommodityInfo.class);
                dycActActivityChangeCommodityRepository.update(activityChangeRelaCommodityInfo);
                check = true;
            } else {
                //不存在插入
                dycActivityChangeRelaCommodityInfo.setCreateUserId(userId);
                dycActivityChangeRelaCommodityInfo.setCreateUserName(name);
                addList.add(dycActivityChangeRelaCommodityInfo);
            }
        }

        if (!CollectionUtils.isEmpty(addList)) {
            DycActivityChangeDO dycActivityChangeDO = new DycActivityChangeDO();
            dycActivityChangeDO.setChangeId(changeId);
            dycActivityChangeDO.setCreateUserName(name);
            dycActivityChangeDO.setCreateUserId(reqBO.getUserId());
            dycActivityChangeDO.setCommodityList(addList);
            dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodity(dycActivityChangeDO);
            //更新商品总数
            int totalCommodity = addList.size();
            if (!CollectionUtils.isEmpty(list)) {
                totalCommodity = totalCommodity + list.size();
            }
            DycActivityChangeInfo set = new DycActivityChangeInfo();
            set.setTotalCommodity(totalCommodity);
            set.setUpdateTime(new Date());
            set.setUpdateUserId(userId);
            set.setUpdateUserName(name);
            DycActivityChangeInfo where = new DycActivityChangeInfo();
            where.setChangeId(changeId);
            dycActActivityChangeRepository.updateByNew(set, where);
            check = false;
        }
        if (check) {
            DycActivityChangeInfo set = new DycActivityChangeInfo();
            set.setUpdateTime(new Date());
            set.setUpdateUserId(userId);
            set.setUpdateUserName(name);
            DycActivityChangeInfo where = new DycActivityChangeInfo();
            where.setChangeId(changeId);
            dycActActivityChangeRepository.updateByNew(set, where);
        }
        rspBO.setFailReasonList(failList);
        return rspBO;
    }

    /**
     * 商品信息设置
     *
     * @return
     */
    private DycActivityChangeRelaCommodityInfo setCommodityInfo(ActSkuInfoBO skuInfoBO) {
        DycActivityChangeRelaCommodityInfo commodityInfo = new DycActivityChangeRelaCommodityInfo();
        commodityInfo.setSkuDetails(skuInfoBO.getSkuPcDetailUrl());
        commodityInfo.setSkuId(skuInfoBO.getSkuId());
        commodityInfo.setCommodityPoolName(skuInfoBO.getPoolNames());
        commodityInfo.setSkuCode(skuInfoBO.getSkuCode());
        commodityInfo.setSkuName(skuInfoBO.getSkuName());
        commodityInfo.setSkuUrl(skuInfoBO.getSkuUrl());
        commodityInfo.setSkuStatus(skuInfoBO.getSkuStatus());
        commodityInfo.setFirstCatalogId(String.valueOf(skuInfoBO.getCatalogId1()));
        commodityInfo.setFirstCatalogName(skuInfoBO.getCatalogName1());
        commodityInfo.setSecondCatalogId(String.valueOf(skuInfoBO.getCatalogId2()));
        commodityInfo.setSecondCatalogName(skuInfoBO.getCatalogName2());
        commodityInfo.setThreeCatalogId(String.valueOf(skuInfoBO.getCatalogId3()));
        commodityInfo.setThreeCatalogName(skuInfoBO.getCatalogName3());
        commodityInfo.setCterminalUrl(skuInfoBO.getJdSkuUrl());
        commodityInfo.setBrand(skuInfoBO.getBrandName());
        commodityInfo.setPrice(skuInfoBO.getAgreementPrice());
        if (skuInfoBO.getGoodRate() != null) {
            commodityInfo.setFavorableRate(skuInfoBO.getGoodRate().doubleValue());
        }
        return commodityInfo;
    }


    /**
     * 商品校验
     *
     * @param list
     * @param importChangeCommodityInfo
     * @param skuInfoBO
     * @return
     */
    private Boolean checkSku(List<DycActImportActivityInfoModelBO> list, ActivityImportChangeCommodityInfo importChangeCommodityInfo, ActSkuInfoBO skuInfoBO) {
        DycActImportActivityInfoModelBO dycActImportActivityInfoModelBO = new DycActImportActivityInfoModelBO();
        if (skuInfoBO == null) {
            dycActImportActivityInfoModelBO.setLineNum(importChangeCommodityInfo.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("未找到商品");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }
        if (!DycActivityConstants.SkuStatue.ON_SALE.equals(skuInfoBO.getSkuStatus())) {
            dycActImportActivityInfoModelBO.setLineNum(importChangeCommodityInfo.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("商品状态不为已上架");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }
        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId1Status())) {
            dycActImportActivityInfoModelBO.setLineNum(importChangeCommodityInfo.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("商品一级类目已停用");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }

        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId2Status())) {
            dycActImportActivityInfoModelBO.setLineNum(importChangeCommodityInfo.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("商品二级类目已停用");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }

        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId3Status())) {
            dycActImportActivityInfoModelBO.setLineNum(importChangeCommodityInfo.getGluttonLineNum());
            dycActImportActivityInfoModelBO.setFailReason("商品三级级类目已停用");
            list.add(dycActImportActivityInfoModelBO);
            return true;
        }
        return false;
    }


    @Override
    public void batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO) {
        dycActActivityChangeUserRepository.batchModifyActivityChangeUserScores(dycActivityChangeDO);
        //查询用户集合信息
        List<String> collect = getUserName(Collections.singletonList(dycActivityChangeDO.getActUserId()),dycActivityChangeDO.getChangeId());
        //更新用户积分操作表记录
        updateChange(collect, ActConstants.ChangeType.DEL, dycActivityChangeDO.getChangeId());
    }

    @Override
    public void modifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO) {
        dycActActivityChangeUserRepository.batchModifyActivityChangeUserScores(dycActivityChangeDO);
        //查询用户集合信息
        List<String> collect = getUserName(Collections.singletonList(dycActivityChangeDO.getActUserId()),dycActivityChangeDO.getChangeId());
        //更新用户积分操作表记录
        updateChange(collect, ActConstants.ChangeType.DEL, dycActivityChangeDO.getChangeId());
    }

    @Override
    public DycActivityChangeInfo changeActivityChangeState(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        if (null == reqBO.getChangeState()) {
            throw new ZTBusinessException("变更单状态不能为空！");
        }
        return dycActActivityChangeRepository.changeActivityChangeState(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityChangeInfo> queryActivityChangePageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeRepository.queryActivityChangePageList(reqBO);
    }

    @Override
    public BasePageRspBo<ActivityChangeUserInfo> queryActivityChangeUserPageList(ActivityChangeUserInfoQryBO reqBo) {
        if (ObjectUtils.isEmpty(reqBo)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBo.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        return dycActActivityChangeUserRepository.queryActivityChangeUserPageList(reqBo);
    }

    @Override
    public List<ActivityChangeUserInfo> queryChangeActivityUserList(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty(reqBo)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBo.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        return dycActActivityChangeUserRepository.queryChangeActivityUserList(reqBo);
    }


    @Override
    public void batchModifyIntegralZeroClearance(DycActivityChangeDO reqBO) {
        dycActActivityChangeUserRepository.batchModifyIntegralZeroClearance(reqBO);
        //查询用户集合信息
        List<String> userName = getUserName(reqBO.getUserIdList(), reqBO.getChangeId());
        //更新用户积分操作表记录
        updateChange(userName, ActConstants.ChangeType.UPDATE, reqBO.getChangeId());
    }

    @Override
    public DycActivityChangeDO qryUserInfoLimitScore(DycActivityChangeDO dycActivityChangeDo) {
        return dycActActivityChangeUserRepository.qryUserInfoLimitScore(dycActivityChangeDo);
    }

    @Override
    public DycActSubmitActivityChangeRspDO submitActivityChange(DycActSubmitActivityChangeReqDO reqBo) {
        //初始化返回值
        DycActSubmitActivityChangeRspDO dycActSubmitActivityChangeRspDo = new DycActSubmitActivityChangeRspDO();
        dycActSubmitActivityChangeRspDo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        dycActSubmitActivityChangeRspDo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        //校验是否有活动没有添加积分数据
        checkUser(reqBo);
        //初始化时间
        Date date = new Date();
        //查询该变更单信息
        DycActivityChangeInfo dycActivityChangeInfo = getDycActivityChangeInfo(reqBo);
        //更新主表数据
        updateInfo(reqBo, date,dycActivityChangeInfo);
        //将之前的附件信息全设置为已删除
        delFile(reqBo);
        //更新附件信息
        updateFile(reqBo);
        //更新原始单据为变更中状态
        updateState(dycActivityChangeInfo);
        return dycActSubmitActivityChangeRspDo;
    }

    /**
     * 校验是否有活动没有添加积分数据
     * @param reqBo
     */
    private void checkUser(DycActSubmitActivityChangeReqDO reqBo) {
        DycActivityChangeUserInfo dycActivityChangeUserInfo = new DycActivityChangeUserInfo();
        dycActivityChangeUserInfo.setChangeId(reqBo.getChangeId());
        int checkByNewByChangeCheck = dycActActivityChangeUserRepository.getCheckByNewByChangeCheck(dycActivityChangeUserInfo);
        if (checkByNewByChangeCheck > 0){
            throw new BaseBusinessException(DycActivityRspConstants.RESP_CODE_ERROR,"您有数据未设置，请设置后提交！");
        }
    }

    /**
     * 更新附件信息
     *
     * @param reqBo
     */
    private void delFile(DycActSubmitActivityChangeReqDO reqBo) {
        DycActivityFileInfo dycActivityFileInfoDelete = new DycActivityFileInfo();
        dycActivityFileInfoDelete.setDelFlag(ActConstants.DelFlag.DEL);
        dycActivityFileInfoDelete.setObjId(reqBo.getChangeId());
        dycActFileRepository.updateByObjId(dycActivityFileInfoDelete);
    }

    /**
     * 更新原始单据为变更中状态
     *
     * @param dycActivityChangeInfo
     */
    private void updateState(DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityDO dycActivityDo = new DycActivityDO();
        dycActivityDo.setActivityId(dycActivityChangeInfo.getOriginalActivityId());
        dycActivityDo.setActivityState(ActConstants.ActivityState.CHANGEING);
        dycActActivityRepository.updateActivityState(dycActivityDo);
    }

    /**
     * 更新附件信息
     *
     * @param reqBo
     */
    private void updateFile(DycActSubmitActivityChangeReqDO reqBo) {
        if (!CollectionUtils.isEmpty(reqBo.getChangeFileList())) {
            List<DycActivityFileInfo> dycActivityFileInfos = new ArrayList<>(reqBo.getChangeFileList().size());
            System.out.println(reqBo.getChangeFileList());
            reqBo.getChangeFileList().forEach(o -> {
                DycActivityFileInfo dycActivityFileInfo = new DycActivityFileInfo();
                dycActivityFileInfo.setObjId(reqBo.getChangeId());
                dycActivityFileInfo.setFileId(Sequence.getInstance().nextId());
                dycActivityFileInfo.setFileName(o.getFileName());
                dycActivityFileInfo.setFileType(o.getFileType());
                dycActivityFileInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
                dycActivityFileInfo.setObjType(ActConstants.ObjType.ACT_CHANGE);
                dycActivityFileInfo.setFileUrl(o.getFileUrl());
                dycActivityFileInfos.add(dycActivityFileInfo);
            });
            dycActFileRepository.addListActivityFileInfo(dycActivityFileInfos);
        }
    }

    /**
     * 查询该变更单信息
     *
     * @param reqBo
     * @return
     */
    private DycActivityChangeInfo getDycActivityChangeInfo(DycActSubmitActivityChangeReqDO reqBo) {
        DycActivityChangeInfo dycActivityChangeDoQry = new DycActivityChangeInfo();
        dycActivityChangeDoQry.setChangeId(reqBo.getChangeId());
        DycActivityChangeInfo dycActivityChangeInfo = dycActActivityChangeRepository.getModelByNew(dycActivityChangeDoQry);
        if (dycActivityChangeInfo == null) {
            throw new ZTBusinessException("查询变更单信息为空！");
        }
        return dycActivityChangeInfo;
    }

    /**
     * 更新主表数据
     *
     * @param reqBo
     * @param date
     */
    private void updateInfo(DycActSubmitActivityChangeReqDO reqBo, Date date,DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityChangeInfo dycActivityChangeDo = new DycActivityChangeInfo();
        dycActivityChangeDo.setChangeId(reqBo.getChangeId());
        dycActivityChangeDo.setChangeReason(reqBo.getChangeReason());
        dycActivityChangeDo.setActivityName(reqBo.getActivityName());
        dycActivityChangeDo.setRemark(reqBo.getRemark());
        dycActivityChangeDo.setPcBannerPicUrl(reqBo.getPcBannerPicUrl());
        dycActivityChangeDo.setPcBannerPicUrl(reqBo.getPcBannerPicUrl());
        dycActivityChangeDo.setActivityStartTime(reqBo.getActivityStartTime());
        dycActivityChangeDo.setActivityEndTime(reqBo.getActivityEndTime());
        dycActivityChangeDo.setMaxPrice(reqBo.getMaxPrice());
        dycActivityChangeDo.setMinPrice(reqBo.getMinPrice());
        dycActivityChangeDo.setUpdateUserId(reqBo.getUserId());
        dycActivityChangeDo.setUpdateUserName(reqBo.getName());
        dycActivityChangeDo.setUpdateTime(date);
        //计算用户数量
        setUserNum(reqBo, dycActivityChangeDo);
        //判断类型计算不同类型数量
        setCommodityItem(dycActivityChangeInfo,dycActivityChangeDo);
        //计算积分总数
        setSore(reqBo, dycActivityChangeDo);
        DycActivityChangeInfo dycActivityChangeDoWhere = new DycActivityChangeInfo();
        dycActivityChangeDoWhere.setChangeId(reqBo.getChangeId());
        dycActActivityChangeRepository.updateByNew(dycActivityChangeDo, dycActivityChangeDoWhere);
    }

    /**
     * 计算积分总数
     * @param reqBo
     * @param dycActivityChangeDo
     */
    private void setSore(DycActSubmitActivityChangeReqDO reqBo, DycActivityChangeInfo dycActivityChangeDo) {
        DycActivityChangeUserInfo dycActivityChangeUserInfo = new DycActivityChangeUserInfo();
        dycActivityChangeUserInfo.setChangeId(reqBo.getChangeId());
        dycActivityChangeUserInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        BigDecimal checkByNewUser = dycActActivityChangeUserRepository.getCheckByNewSoreCount(dycActivityChangeUserInfo);
        dycActivityChangeDo.setTotalScores(checkByNewUser);
    }

    /**
     * 计算用户数量
     * @param reqBo
     * @param dycActivityChangeDo
     */
    private void setUserNum(DycActSubmitActivityChangeReqDO reqBo, DycActivityChangeInfo dycActivityChangeDo) {
        //计算用户数量
        DycActivityChangeUserInfo dycActivityChangeUserInfo = new DycActivityChangeUserInfo();
        dycActivityChangeUserInfo.setChangeId(reqBo.getChangeId());
        dycActivityChangeUserInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        int checkByNewUser = dycActActivityChangeUserRepository.getCheckByNew(dycActivityChangeUserInfo);
        dycActivityChangeDo.setTotalUser(checkByNewUser);
    }

    /**
     * 根据不同类型查询商品信息
     *
     * @param dycActivityChangeInfo
     */
    private void setCommodityItem(DycActivityChangeInfo dycActivityChangeInfo,DycActivityChangeInfo dycActivityChangeDo) {
        switch (String.valueOf(dycActivityChangeInfo.getCommodityRelaMethod())) {
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_TWO:
                dealCatalogNum(dycActivityChangeInfo,dycActivityChangeDo);
                break;
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_THREE:
                dealCommodityNum(dycActivityChangeInfo,dycActivityChangeDo);
                break;
            default:
                break;
        }
    }

    /**
     * 计算商品数量
     * @param dycActivityChangeInfo
     * @param dycActivityChangeDo
     */
    private void dealCommodityNum(DycActivityChangeInfo dycActivityChangeInfo,DycActivityChangeInfo dycActivityChangeDo){
        DycActivityChangeRelaCommodityInfo dycActivityChangeRelaCommodityInfo = new DycActivityChangeRelaCommodityInfo();
        dycActivityChangeRelaCommodityInfo.setChangeId(dycActivityChangeInfo.getChangeId());
        dycActivityChangeRelaCommodityInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        int checkByNew = dycActActivityChangeCommodityRepository.getCheckByNew(dycActivityChangeRelaCommodityInfo);
        dycActivityChangeDo.setTotalCommodity(checkByNew);
        dycActivityChangeDo.setTotalCatalog(0);
    }

    /**
     * 计算商品类目数量
     * @param dycActivityChangeInfo
     * @param dycActivityChangeDo
     */
    private void dealCatalogNum(DycActivityChangeInfo dycActivityChangeInfo,DycActivityChangeInfo dycActivityChangeDo){
        DycActivityChangeRelaCommodityCatalogInfo dycActivityChangeRelaCommodityCatalogInfo = new DycActivityChangeRelaCommodityCatalogInfo();
        dycActivityChangeRelaCommodityCatalogInfo.setChangeId(dycActivityChangeInfo.getChangeId());
        dycActivityChangeRelaCommodityCatalogInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        int checkByNew = dycActActivityChangeCommodityCatalogRepository.getCheckByNew(dycActivityChangeRelaCommodityCatalogInfo);
        dycActivityChangeDo.setTotalCatalog(checkByNew);
        dycActivityChangeDo.setTotalCommodity(0);
    }


    @Override
    public DycActDealAppApproveActivityRspBo dealAppApprove(DycActDealAppApproveActivityReqBo reqBo) {
        //初始化时间
        Date date = new Date();
        //初始化返回参数
        DycActDealAppApproveActivityRspBo dycActDealAppApproveActivityRspBo = new DycActDealAppApproveActivityRspBo();
        dycActDealAppApproveActivityRspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        dycActDealAppApproveActivityRspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        //根据审批结果做不同操作
        if (reqBo.getApproveResult()) {
            //初始化原状态
            String state = ActConstants.ActivityState.CHANGEING;
            //新增变更ID
            Long newId = Sequence.getInstance().nextId();
            //复制变更表数据至主表，并且将之前主表数据置为已删除，更新变更数据为审批通过，新表数据变为对应状态
            //查询变更表数据
            DycActivityChangeInfo dycActivityChangeInfo = getDycActivityChangeInfo(reqBo);
            //查询变更用户数据
            List<DycActivityChangeUserInfo> activityChangeUserInfoList = getDycActivityChangeUserInfos(reqBo);
            //查询变更供应商数据
            List<DycActivityChangeSupplierInfo> activityChangeUserInfoSupList = getDycActivityChangeSupplierInfos(reqBo);
            //根据不同类型查询并新增商品信息
            setOrgItem(dycActivityChangeInfo, newId, date);
            //处理变更表数据
            setInfo(date, state, newId, dycActivityChangeInfo);
            //处理变更用户数据
            setUser(date, newId, activityChangeUserInfoList);
            //处理变更供应商数据
            setSup(newId, activityChangeUserInfoSupList);
            //将之前主表数据置为已删除
            setDel(dycActivityChangeInfo);
           /* //将之前用户表数据置为已删除
            setDelUser(dycActivityChangeInfo);*/
            //更新变更数据为审批通过
            setPass(dycActivityChangeInfo);
            //设置返回值
            dycActDealAppApproveActivityRspBo.setActivityId(newId);
        } else {
            //更新原始活动数据为之前状态，更新变更数据为审批驳回
            //查询变更表数据
            DycActivityChangeInfo dycActivityChangeInfo = getDycActivityChangeInfoFail(reqBo);
            //更新原始活动数据为之前状态
            setFail(dycActivityChangeInfo);
        }
        return dycActDealAppApproveActivityRspBo;
    }

   /* *//**
     * 将之前用户表数据置为已删除
     * @param dycActivityChangeInfo
     *//*
    private void setDelUser(DycActivityChangeInfo dycActivityChangeInfo){
        DycActivityUserInfo dycActivityUserInfoWhere = new DycActivityUserInfo();
        dycActivityUserInfoWhere.setActivityId(dycActivityChangeInfo.getOriginalActivityId());
        DycActivityUserInfo dycActivityUserInfoSet = new DycActivityUserInfo();
        dycActivityUserInfoSet.setDelFlag(ActConstants.DelFlag.DEL);
        dycActActivityUserRepository.updateByNew(dycActivityUserInfoSet,dycActivityUserInfoWhere);
    }*/

    /**
     * 更新原始活动数据为之前状态
     * @param dycActivityChangeInfo
     */
    private void setFail(DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityBaseInfo dycActivityBaseInfoWhere = new DycActivityBaseInfo();
        dycActivityBaseInfoWhere.setActivityId(dycActivityChangeInfo.getOriginalActivityId());
        DycActivityBaseInfo dycActivityBaseInfoSet = new DycActivityBaseInfo();
        dycActivityBaseInfoSet.setActivityState(dycActivityChangeInfo.getOriginalActivityState());
        dycActActivityRepository.updateByNew(dycActivityBaseInfoSet,dycActivityBaseInfoWhere);
        //更新变更数据为审批驳回
        DycActivityChangeInfo dycActivityChangeDoSet = new DycActivityChangeInfo();
        dycActivityChangeDoSet.setChangeState(ActConstants.ChangeState.FAIL);
        DycActivityChangeInfo dycActivityChangeDoWhere = new DycActivityChangeInfo();
        dycActivityChangeDoWhere.setChangeId(dycActivityChangeInfo.getChangeId());
        dycActActivityChangeRepository.updateByNew(dycActivityChangeDoSet, dycActivityChangeDoWhere);
    }

    /**
     * 查询变更表数据
     * @param reqBo
     * @return
     */
    private DycActivityChangeInfo getDycActivityChangeInfoFail(DycActDealAppApproveActivityReqBo reqBo) {
        //查询变更表数据
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setChangeId(reqBo.getChangeId());
        DycActivityChangeInfo dycActivityChangeInfo = dycActActivityChangeRepository.queryActivityChangeBaseInfo(dycActivityChangeDo);
        if (dycActivityChangeInfo == null) {
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "查询变更表数据为空！");
        }
        return dycActivityChangeInfo;
    }

    /**
     * setPass
     * @param dycActivityChangeInfo
     */
    private void setPass(DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityChangeInfo dycActivityChangeDoSet = new DycActivityChangeInfo();
        dycActivityChangeDoSet.setChangeState(ActConstants.ChangeState.PASS);
        DycActivityChangeInfo dycActivityChangeDoWhere = new DycActivityChangeInfo();
        dycActivityChangeDoWhere.setChangeId(dycActivityChangeInfo.getChangeId());
        dycActActivityChangeRepository.updateByNew(dycActivityChangeDoSet, dycActivityChangeDoWhere);
    }

    /**
     * 将之前主表数据置为已删除
     * @param dycActivityChangeInfo
     */
    private void setDel(DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityBaseInfo dycActivityBaseInfoWhere = new DycActivityBaseInfo();
        dycActivityBaseInfoWhere.setActivityId(dycActivityChangeInfo.getOriginalActivityId());
        DycActivityBaseInfo dycActivityBaseInfoSet = new DycActivityBaseInfo();
        dycActivityBaseInfoSet.setDelFlag(ActConstants.DelFlag.DEL);
        dycActActivityRepository.updateByNew(dycActivityBaseInfoSet, dycActivityBaseInfoWhere);
    }

    /**
     * 处理变更供应商数据
     * @param newId
     * @param activityChangeUserInfoSupList
     */
    private void setSup(Long newId, List<DycActivityChangeSupplierInfo> activityChangeUserInfoSupList) {
        List<DycActivitySupplierInfo> dycActivityChangeSupplierInfos = JSONObject.parseArray(JSONObject.toJSONString(activityChangeUserInfoSupList), DycActivitySupplierInfo.class);
        dycActivityChangeSupplierInfos.forEach(o -> {
            o.setActivityId(newId);
            o.setId(Sequence.getInstance().nextId());
        });
        dycActActivitySupplierRepository.insertBatchNew(dycActivityChangeSupplierInfos);
    }

    /**
     * 处理变更用户数据
     * @param date
     * @param newId
     * @param activityChangeUserInfoList
     */
    private void setUser(Date date, Long newId, List<DycActivityChangeUserInfo> activityChangeUserInfoList) {
        List<DycActivityUserInfo> dycActivityUserInfoList = JSONObject.parseArray(JSONObject.toJSONString(activityChangeUserInfoList), DycActivityUserInfo.class);
        dycActivityUserInfoList.forEach(o -> {
            o.setActivityId(newId);
            o.setId(Sequence.getInstance().nextId());
            o.setCreateTime(date);
        });
        dycActActivityUserRepository.insertBatchNew(dycActivityUserInfoList);
    }

    /**
     * 处理变更表数据
     * @param date
     * @param state
     * @param newId
     * @param dycActivityChangeInfo
     */
    private void setInfo(Date date, String state, Long newId, DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityBaseInfo dycActivityBaseInfo = JSONObject.parseObject(JSONObject.toJSONString(dycActivityChangeInfo), DycActivityBaseInfo.class);
        dycActivityBaseInfo.setActivityId(newId);
        dycActivityBaseInfo.setActivityCode(dycActivityChangeInfo.getNewActivityCode());
        dycActivityBaseInfo.setActivityVersion(dycActivityChangeInfo.getNewActivityVersion());
        //计算状态
        if (dycActivityChangeInfo.getActivityEndTime().compareTo(date) >= 0 && dycActivityChangeInfo.getActivityStartTime().compareTo(date) <= 0){
            state = ActConstants.ActivityState.CLOSE;
        }else if (dycActivityChangeInfo.getActivityStartTime().compareTo(date) > 0){
            state = ActConstants.ActivityState.NO_ACTIVE;
        }else if (dycActivityChangeInfo.getActivityStartTime().compareTo(date) < 0){
            state = ActConstants.ActivityState.NO_ACTIVE;
        }
        dycActivityBaseInfo.setActivityState(state);
        dycActActivityRepository.insertNew(dycActivityBaseInfo);
    }

    /**
     * 查询变更供应商数据
     * @param reqBo
     * @return
     */
    private List<DycActivityChangeSupplierInfo> getDycActivityChangeSupplierInfos(DycActDealAppApproveActivityReqBo reqBo) {
        DycActivityChangeSupplierInfo dycActivityChangeDoChangeSup = new DycActivityChangeSupplierInfo();
        dycActivityChangeDoChangeSup.setChangeId(reqBo.getChangeId());
        List<DycActivityChangeSupplierInfo> activityChangeUserInfoSupList = dycActActivityChangeSupplierRepository.getListNew(dycActivityChangeDoChangeSup);
        if (CollectionUtils.isEmpty(activityChangeUserInfoSupList)) {
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "查询变更供应商表数据为空！");
        }
        return activityChangeUserInfoSupList;
    }

    /**
     * 查询变更用户数据
     * @param reqBo
     * @return
     */
    private List<DycActivityChangeUserInfo> getDycActivityChangeUserInfos(DycActDealAppApproveActivityReqBo reqBo) {
        DycActivityChangeUserInfo dycActivityChangeDoChange = new DycActivityChangeUserInfo();
        dycActivityChangeDoChange.setChangeId(reqBo.getChangeId());
        dycActivityChangeDoChange.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<DycActivityChangeUserInfo> activityChangeUserInfoList = dycActActivityChangeUserRepository.getListNew(dycActivityChangeDoChange);
        if (CollectionUtils.isEmpty(activityChangeUserInfoList)) {
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "查询变更用户表数据为空！");
        }
        return activityChangeUserInfoList;
    }

    /**
     * 查询变更表数据
     * @param reqBo
     * @return
     */
    private DycActivityChangeInfo getDycActivityChangeInfo(DycActDealAppApproveActivityReqBo reqBo) {
        DycActivityChangeInfo dycActivityChangeDo = new DycActivityChangeInfo();
        dycActivityChangeDo.setChangeId(reqBo.getChangeId());
        dycActivityChangeDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityChangeInfo dycActivityChangeInfo = dycActActivityChangeRepository.getModelByNew(dycActivityChangeDo);
        if (dycActivityChangeInfo == null) {
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "查询变更表数据为空！");
        }
        return dycActivityChangeInfo;
    }

    /**
     * 根据不同类型查询商品信息
     *
     * @param dycActivityChangeInfo
     */
    private void setOrgItem(DycActivityChangeInfo dycActivityChangeInfo, Long newId, Date date) {
        switch (String.valueOf(dycActivityChangeInfo.getCommodityRelaMethod())) {
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_TWO:
                dealCatalog(dycActivityChangeInfo, newId, date);
                break;
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_THREE:
                dealCommodity(dycActivityChangeInfo, newId, date);
                break;
            default:
                break;
        }
    }

    /**
     * 商品类目处理
     *
     * @param dycActivityChangeInfo
     */
    private void dealCatalog(DycActivityChangeInfo dycActivityChangeInfo, Long newId, Date date) {
        //查询商品类目数据
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setChangeId(dycActivityChangeInfo.getChangeId());
        List<DycActivityChangeRelaCommodityCatalogInfo> list = dycActActivityChangeCommodityRepository.getListCatalog(dycActivityChangeDo);
        if (CollectionUtils.isEmpty(list)) {
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "查询变更商品类目数据为空！");
        }
        //复制商品类目数据
        List<DycActiveCommodityCatalogInfo> dycActiveCommodityCatalogInfoList = JSONObject.parseArray(JSONObject.toJSONString(list), DycActiveCommodityCatalogInfo.class);
        dycActiveCommodityCatalogInfoList.forEach(o -> {
            o.setActivityId(newId);
            o.setRelaId(Sequence.getInstance().nextId());
            o.setCreateTime(date);
        });
        dycActActivityCommodityRepository.insertAllCatalog(dycActiveCommodityCatalogInfoList);
    }

    /**
     * 商品处理
     *
     * @param dycActivityChangeInfo
     */
    private void dealCommodity(DycActivityChangeInfo dycActivityChangeInfo, Long newId, Date date) {
        //查询商品数据
        ActivityChangeRelaCommodityInfo activityChangeRelaCommodityInfo = new ActivityChangeRelaCommodityInfo();
        activityChangeRelaCommodityInfo.setChangeId(dycActivityChangeInfo.getChangeId());
        List<ActivityChangeRelaCommodityInfo> list = dycActActivityChangeCommodityRepository.getList(activityChangeRelaCommodityInfo);
        if (CollectionUtils.isEmpty(list)) {
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "查询变更商品数据为空！");
        }
        //复制商品数据
        List<DycActActivityRelaCommodityInfo> dycActActivityRelaCommodityInfoList = JSONObject.parseArray(JSONObject.toJSONString(list), DycActActivityRelaCommodityInfo.class);
        dycActActivityRelaCommodityInfoList.forEach(o -> {
            o.setActivityId(newId);
            o.setRelaId(Sequence.getInstance().nextId());
            o.setCreateTime(date);
        });
        dycActActivityCommodityRepository.insertAllCommodity(dycActActivityRelaCommodityInfoList);
    }

    @Override
    public DycActQuerySyncActivityUserChangeListRspBo queryActivityUserChangeScoreList(DycActQuerySyncActivityUserChangeListReqBo reqBo) {
        DycActQuerySyncActivityUserChangeListRspBo dycActQuerySyncActivityUserChangeListRspBo = new DycActQuerySyncActivityUserChangeListRspBo();
        ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo = new ActActivityChangeUserScoresChangeDO();
        actActivityChangeUserScoresChangeDo.setChangeId(reqBo.getChangeId());
        List<ActActivityChangeUserScoresChangeDO> list = actActivityChangeUserScoresChangeRepository.getList(actActivityChangeUserScoresChangeDo);
        if (CollectionUtils.isEmpty(list)){
            dycActQuerySyncActivityUserChangeListRspBo.setSyncUserScoreBoList(new ArrayList<>());
            return dycActQuerySyncActivityUserChangeListRspBo;
        }
        List<SyncUserScoreBoList> syncUserScoreBoList = new ArrayList<>();
        for (ActActivityChangeUserScoresChangeDO o : list) {
            if (o.getOriginalScores() == null){
                SyncUserScoreBoList syncUserScoreBo = new SyncUserScoreBoList();
                syncUserScoreBo.setGiveScores(o.getAfterChangeScores());
                syncUserScoreBo.setActUserId(o.getUserId());
                syncUserScoreBoList.add(syncUserScoreBo);
            }else if (o.getOriginalScores() != null && o.getAfterChangeScores() != null && o.getOriginalScores().compareTo(o.getAfterChangeScores()) != 0){
                SyncUserScoreBoList syncUserScoreBo = new SyncUserScoreBoList();
                syncUserScoreBo.setGiveScores(o.getAfterChangeScores().subtract(o.getOriginalScores()));
                syncUserScoreBo.setActUserId(o.getUserId());
                syncUserScoreBoList.add(syncUserScoreBo);
            }else if (o.getAfterChangeScores() == null){
                throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL,"查询活动变更积分同步接口数据有误");
            }
        }
        dycActQuerySyncActivityUserChangeListRspBo.setSyncUserScoreBoList(syncUserScoreBoList);
        return dycActQuerySyncActivityUserChangeListRspBo;
    }
}
