package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.ActActivityChangeUserScoresChangeDO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 标题：ActActivityChangeUserScoresChangeRepository
 * 说明：活动变更积分记录表
 * 时间：2024/4/16 7:56 下午
 * 作者：汪成松
 */

public interface ActActivityChangeUserScoresChangeRepository {
    /**
     * 插入单条数据
     *
     * @param actActivityChangeUserScoresChangeDo 参数对象
     * @return int 影响数量
     */
    int insert(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo);

    /**
     * 根据条件删除数据
     *
     * @param actActivityChangeUserScoresChangeDo 参数对象
     * @return int 影响数量
     */
    int deleteBy(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo);

    /**
     * 根据主键更新数据
     *
     * @param actActivityChangeUserScoresChangeDo 参数对象
     * @return int 影响数量
     * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
     */
    @Deprecated
    int updateById(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActActivityChangeUserScoresChangeDO set, @Param("where") ActActivityChangeUserScoresChangeDO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param actActivityChangeUserScoresChangeDo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo);

    /**
     * 根据条件查询单条数据
     *
     * @param actActivityChangeUserScoresChangeDo 参数对象
     * @return ActActivityChangeUserScoresChangePO 结果对象
     */
    ActActivityChangeUserScoresChangeDO getModelBy(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo);

    /**
     * 根据条件查询列表数据
     *
     * @param actActivityChangeUserScoresChangeDo 参数对象
     * @return List<ActActivityChangeUserScoresChangePO> 结果对象
     */
    List<ActActivityChangeUserScoresChangeDO> getList(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActActivityChangeUserScoresChangeDO> list);
}
