package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;


/**
 * 描述: 〈活动商品变更基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:28
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityChangeCommodityRepository {
    /**
     * 描述:活动变更已选商品类型列表查询（分页）服务
     *
     * @param
     * @return void
     */
    BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> queryActivityChangeSelectedCommodityCatalogPageList(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更已选商品池列表查询（分页）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.base.bo.BasePageRspBo<com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo>
     */
    BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> queryActivityChangeCommodityPoolPageList(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更商品池选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo
     */
    DycActivityChangeRelaCommodityPoolInfo batchSelectActivityChangeCommodityPool(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更商品池移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo
     */
    DycActivityChangeRelaCommodityPoolInfo batchRemoveActivityChangeCommodityPool(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更商品选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityInfo
     */
    int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更商品类型选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo
     */
    int batchSelectActivityChangeCommodityCatalog(DycActivityChangeDO reqBO);

    /**
     * 活动变更商品类型移除（批量）服务
     * @param reqBO
     * @return
     */
    int batchRemoveActivityChangeCommodityCatalog(DycActivityChangeDO reqBO);

    /**
     * 活动变更已选商品列表查询（分页）服务
     * @param qryDO
     * @return
     */
    BasePageRspBo<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(ActActivityChangeCommodityInfoQryDO qryDO);

    /**
     * 活动变更商品移除（批量）服务
     * @param reqBO
     * @return
     */
    int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO);

    /**
     * 活动变更已选商品列表
     * @param reqBO
     * @return
     */
    List<ActivityChangeRelaCommodityInfo> getList(ActivityChangeRelaCommodityInfo reqBO);

    /**
     * 更新活动变更已选商品
     * @param reqBO
     */
    void update(ActivityChangeRelaCommodityInfo reqBO);

    /**
     * 描述:活动变更已选商品类型列表查询（分页）服务
     *
     * @param
     * @return void
     */
    List<DycActivityChangeRelaCommodityCatalogInfo> getListCatalog(DycActivityChangeDO reqBo);

    /**
     * 插入单条数据
     *
     * @param reqBo 参数对象
     * @return int 影响数量
     */
    int insertNew(DycActivityChangeRelaCommodityInfo reqBo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateByNew(DycActivityChangeRelaCommodityInfo set, DycActivityChangeRelaCommodityInfo where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNew(DycActivityChangeRelaCommodityInfo reqBo);

    /**
     * 根据条件查询单条数据
     *
     * @param reqBo 参数对象
     * @return ActActivityChangeRelaCommodityPO 结果对象
     */
    DycActivityChangeRelaCommodityInfo getModelByNew(DycActivityChangeRelaCommodityInfo reqBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<ActActivityChangeRelaCommodityPO> 结果对象
     */
    List<DycActivityChangeRelaCommodityInfo> getListNew(DycActivityChangeRelaCommodityInfo reqBo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatchNew(List<DycActivityChangeRelaCommodityInfo> list);
}
