package com.tydic.dyc.act.repository.api;


import com.tydic.dyc.act.model.bo.DycActActivityChangeApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动变更实体基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:27
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityChangeRepository {

    /**
     * 描述:活动变更单基本信息查询服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    DycActivityChangeInfo queryActivityChangeBaseInfo(DycActivityChangeDO reqBO);

    /**
     * 描述:变更单基本信息保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeInfo
     */
    DycActivityChangeInfo saveActiveChangeBaseInfo(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更状态变更服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeInfo
     */
    DycActivityChangeInfo changeActivityChangeState(DycActivityChangeDO reqBO);

    /**
     * 活动变更列表查询（分页）服务
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityChangeInfo> queryActivityChangePageList(DycActivityChangeDO reqBO);

    /**
     *
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActActivityChangeApproveBaseInfo> queryActivityChangeApprovePageList(DycProcessDO reqBO);

    /**
     * 活动变更列表
     * @param dycActivityChangeInfo
     * @return
     */
    List<DycActivityChangeInfo> getList(DycActivityChangeInfo dycActivityChangeInfo);

    /**
     * 活动变更根据主键ID更新主表信息
     * @param reqBo
     * @return
     */
    void updateByCondition(DycActivityChangeDO reqBo);

    /**
     * 插入单条数据
     *
     * @param reqBo 参数对象
     * @return int 影响数量
     */
    int insertNew(DycActivityChangeInfo reqBo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateByNew(DycActivityChangeInfo set,DycActivityChangeInfo where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNew(DycActivityChangeInfo reqBo);

    /**
     * 根据条件查询单条数据
     *
     * @param reqBo 参数对象
     * @return DycActActivityApproveBaseInfoPO 结果对象
     */
    DycActivityChangeInfo getModelByNew(DycActivityChangeInfo reqBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<DycActActivityApproveBaseInfoPO> 结果对象
     */
    List<DycActivityChangeInfo> getListNew(DycActivityChangeInfo reqBo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatchNew(List<DycActivityChangeInfo> list);

    List<DycActivityChangeInfo> qrySum(List<String> reqBO);
}
