package com.tydic.dyc.act.repository.api;


import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeSupplierInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动变更供应商基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:30
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityChangeSupplierRepository {
    /**
     * 活动变更已选供应商列表查询（分页）服务
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityChangeSupplierInfo> queryActivityChangeSelectedSupplierPageList(DycActivityChangeDO reqBO);

    /**
     * 活动变更供应商选择（批量）服务
     * @param reqBO
     * @return
     */
    int batchSelectActivityChangeSupplier(DycActivityChangeDO reqBO);

    /**
     * 活动变更供应商移除（批量）服务
     * @param reqBO
     * @return
     */
    int batchRemoveActivityChangeSupplier(DycActivityChangeDO reqBO);

    /**
     * 活动变更供应商移除（批量）服务
     * @param reqBO
     * @return
     */
    List<DycActivityChangeSupplierInfo> qryActivityChangeSelectedSupplierList(DycActivityChangeDO reqBO);

    /**
     * 插入单条数据
     *
     * @param reqBo 参数对象
     * @return int 影响数量
     */
    int insertNew(DycActivityChangeSupplierInfo reqBo);


    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateByNew(DycActivityChangeSupplierInfo set,DycActivityChangeSupplierInfo where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNew(DycActivityChangeSupplierInfo reqBo);

    /**
     * 根据条件查询单条数据
     *
     * @param reqBo 参数对象
     * @return ActActivityChangeSupplierInfoPO 结果对象
     */
    DycActivityChangeSupplierInfo getModelByNew(DycActivityChangeSupplierInfo reqBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<ActActivityChangeSupplierInfoPO> 结果对象
     */
    List<DycActivityChangeSupplierInfo> getListNew(DycActivityChangeSupplierInfo reqBo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatchNew(List<DycActivityChangeSupplierInfo> list);
}
