package com.tydic.dyc.act.repository.api;


import com.tydic.dyc.act.model.bo.ActivityChangeUserInfo;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfoQryBO;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 描述: 〈活动变更用户基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:29
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityChangeUserRepository {
    /**
     * 描述:活动用户变更选择（批量）
     *
     * @param reqBO
     */
    void batchSelectActivityChangeUser(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更已选用户列表查询（分页）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo
     */
    BasePageRspBo<ActivityChangeUserInfo> queryActivityChangeUserPageList(ActivityChangeUserInfoQryBO reqBO);
    /**
     * 描述:活动变更用户移除（批量）服务
     *
     * @param reqBO
     * @return int
     */
    int batchRemoveActivityChangeUser(DycActivityChangeDO reqBO);

    /**
     * 根据变更单id查询用户
     * @param dycActivityChangeDO
     * @return
     */
    List<ActivityChangeUserInfo> queryChangeActivityUserList(DycActivityChangeDO dycActivityChangeDO);

    /**
     * 变更用户新增
     * @param dycActivityUserInfo
     */
    int addChangeUser(DycActivityChangeDO dycActivityUserInfo);

    /**
     * 活动变更用户积分修改（批量）服务
     * @param dycActivityChangeDO
     */
    void batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO);

    /**
     * 活动变更用户积分修改（批量）服务
     * @param dycActivityChangeDo
     * @return
     */
    void batchModifyIntegralZeroClearance(DycActivityChangeDO dycActivityChangeDo);

    /**
     * 更新活动变更用户信息
     * @param dycActivityChangeUserInfo
     */
    void update(DycActivityChangeUserInfo dycActivityChangeUserInfo);

    /**
     * 活动变更-积分发放超额提醒API（服务）
     * @param dycActivityChangeDo
     * @return
     */
    DycActivityChangeDO qryUserInfoLimitScore(DycActivityChangeDO dycActivityChangeDo);
    /**
     * 根据变更单id查询用户
     * @param dycActivityChangeDO
     * @return
     */
    List<ActivityChangeUserInfo> queryChangeActivityUserListAll(DycActivityChangeDO dycActivityChangeDO);

    /**
     * 插入单条数据
     *
     * @param reqBo 参数对象
     * @return int 影响数量
     */
    int insertNew(DycActivityChangeUserInfo reqBo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateByNew(DycActivityChangeUserInfo set, DycActivityChangeUserInfo where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNew(DycActivityChangeUserInfo reqBo);

    /**
     * 根据条件查询单条数据
     *
     * @param reqBo 参数对象
     * @return ActActivityChangeUserInfoPO 结果对象
     */
    DycActivityChangeUserInfo getModelByNew(DycActivityChangeUserInfo reqBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<ActActivityChangeUserInfoPO> 结果对象
     */
    List<DycActivityChangeUserInfo> getListNew(DycActivityChangeUserInfo reqBo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatchNew(List<DycActivityChangeUserInfo> list);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    BigDecimal getCheckByNewSoreCount(DycActivityChangeUserInfo reqBo);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNewByChangeCheck(DycActivityChangeUserInfo reqBo);
}
