package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo ;

import java.util.List;

/**
 * 标题：DycActActivityCommodityCatalogRepository
 * 说明：商品类目
 * 时间：2024/4/17 7:47 下午
 * 作者：汪成松
 */
public interface DycActActivityCommodityCatalogRepository {
    /**
     * 插入单条数据
     *
     * @param reqBo 参数对象
     * @return int 影响数量
     */
    int insertNew(DycActiveCommodityCatalogInfo  reqBo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateByNew(DycActiveCommodityCatalogInfo  set, DycActiveCommodityCatalogInfo  where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNew(DycActiveCommodityCatalogInfo  reqBo);

    /**
     * 根据条件查询单条数据
     *
     * @param reqBo 参数对象
     * @return ActActivityRelaCommodityPO 结果对象
     */
    DycActiveCommodityCatalogInfo  getModelByNew(DycActiveCommodityCatalogInfo  reqBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<ActActivityRelaCommodityPO> 结果对象
     */
    List<DycActiveCommodityCatalogInfo > getListNew(DycActiveCommodityCatalogInfo  reqBo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatchNew(List<DycActiveCommodityCatalogInfo> list);
}
