package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动商品基建方法〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:28
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityCommodityRepository {

    /**
     * 描述:活动已选商品池列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo
     */
    BasePageRspBo<DycActivityCommodityPoolInfo> queryActivityCommodityPoolPageList(DycQueryActivityCommodityPoolPageListReqBO reqBO);

    /**
     * 描述:活动已选商品池列表查询
     *
     * @param reqBO
     * @return java.util.List<com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo>
     */
    List<DycActivityCommodityPoolInfo> queryActivityCommodityPoolList(DycQueryActivityCommodityPoolPageListReqBO reqBO);

    /**
     * 活动已选商品列表分页查询
     *
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO);

    /**
     * 描述:活动已选商品列表查询
     *
     * @param reqBO
     * @return java.util.List<com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo>
     */
    List<DycActActivityRelaCommodityInfo> queryActivityCommodityList(DycActivityDO reqBO);

    /**
     * 描述:活动已选商品类型列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.base.bo.BasePageRspBo<com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo>
     */
    BasePageRspBo<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogList(DycActiveCommodityCatalogQueryBO reqBO);

    /**
     * 描述:活动已选商品类型列表查询
     *
     * @param reqBO
     * @return java.util.List<com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo>
     */
    List<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogAllList(DycActiveCommodityCatalogQueryBO reqBO);

    /**
     * 描述:活动商品池选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo
     */
    DycActivityCommodityPoolInfo batchSelectActivityCommodityPool(DycActivityDO reqBO);

    /**
     * 活动商品池移除（批量）服务
     *
     * @param reqBO
     * @return
     */
    int batchRemoveActivityCommodityPool(DycActivityDO reqBO);

    /**
     * 描述:活动商品类型选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo
     */
    DycActiveCommodityCatalogInfo batchSelectActivityCommodityCatalog(DycActivityDO reqBO);

    /**
     * 活动商品类型移除（批量）服务
     *
     * @param reqBO
     * @return
     */
    int batchRemoveActivityCommodityCatalog(DycActivityDO reqBO);

    /**
     * 描述:活动商品选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    DycActActivityRelaCommodityInfo batchSelectActivityCommodity(DycActivityDO reqBO);

    /**
     * 活动商品移除（批量）服务
     *
     * @param reqBO
     * @return
     */
    int batchRemoveActivityCommodity(DycActivityDO reqBO);

    /**
     * 根据活动id移除活动商品类型
     *
     * @param reqBO
     * @return
     */
    int deleteActivityCommodityCatalog(DycActivityDO reqBO);

    /**
     * 根据活动id移除活动商品
     *
     * @param reqBO
     * @return
     */
    int deleteActivityCommodity(DycActivityDO reqBO);

    int selectCountCommodity(DycActivityDO reqBO);

    int selectCountCommodityCatalog(DycActivityDO reqBO);

    /**
     * 更新活动商品
     *
     * @param reqBO
     * @return
     */
    int updateCommodity(DycActActivityRelaCommodityInfo reqBO);

    /**
     * 描述:活动商品新增（批量）服务
     *
     * @param dycActActivityRelaCommodityInfoList
     * @return com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo
     */
    void insertAllCommodity(List<DycActActivityRelaCommodityInfo> dycActActivityRelaCommodityInfoList);


    /**
     * 描述:活动商品类型新增（批量）服务
     *
     * @param dycActiveCommodityCatalogInfoList
     * @return com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo
     */
    void insertAllCatalog(List<DycActiveCommodityCatalogInfo> dycActiveCommodityCatalogInfoList);

    /**
     * 插入单条数据
     *
     * @param reqBo 参数对象
     * @return int 影响数量
     */
    int insertNew(DycActActivityRelaCommodityInfo reqBo);

    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateByNew(DycActActivityRelaCommodityInfo set, DycActActivityRelaCommodityInfo where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNew(DycActActivityRelaCommodityInfo reqBo);

    /**
     * 根据条件查询单条数据
     *
     * @param reqBo 参数对象
     * @return ActActivityRelaCommodityPO 结果对象
     */
    DycActActivityRelaCommodityInfo getModelByNew(DycActActivityRelaCommodityInfo reqBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<ActActivityRelaCommodityPO> 结果对象
     */
    List<DycActActivityRelaCommodityInfo> getListNew(DycActActivityRelaCommodityInfo reqBo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatchNew(List<DycActActivityRelaCommodityInfo> list);

    /**
     * 描述: 用作于商品与类型切换时，清空商品
     *
     * @param reqBO
     * @return int
     */
    int updateCommodityState(DycActivityDO reqBO);

    /**
     * 根据条件删除关联的商品类目
     *
     * @param reqBo
     * @return
     */
    int updateActiveCommodityCatalogInfoBy(DycActiveCommodityCatalogInfo reqBo);

    List<DycActActivityRelaCommodityInfo> selectByOnShelf(DycActivityDO reqBO);
}
