package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动实体基建方法〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:27
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityRepository {

    /**
     * 根据条件查询活动基本信息列表（分页）
     *
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO);

    /**
     * 根据条件查询活动基本信息列表
     *
     * @param reqBO
     * @return
     */
    List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO);

    /**
     * 描述: 活动基本详情保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityFileInfo
     */
    DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO);

    /**
     * 活动状态变更服务
     *
     * @param reqBO
     * @return
     */
    int changeActivityState(DycActivityDO reqBO);

    /**
     * 活动删除服务
     *
     * @param reqBO
     * @return
     */
    int deleteActivity(DycActivityDO reqBO);

    /**
     * 活动自动生效定时任务服务
     *
     * @param reqBO
     * @return 活动id集合
     */
    List<Long> autoEffectActivity(DycActivityDO reqBO);

    /**
     * 描述:活动自动失效定时任务服务
     *
     * @param
     * @return void
     */
    DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO);

    /**
     * 活动审批列表查询（分页）服务
     *
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO);

    /**
     * 描述:活动状态更新服务
     *
     * @param reqBO
     * @return int
     */
    int updateActivityState(DycActivityDO reqBO);

    /**
     * 描述: 活动基本详情查询
     *
     * @param reqBo
     * @return com.tydic.dyc.act.model.bo.DycActivityFileInfo
     */
    DycActivityBaseInfo qryActiveBaseInfo(DycActivityDO reqBo);

    /**
     *  活动详情查询
     * @param dycActivityDO 入参
     * @return
     */
    DycActivityBaseInfo getActivityBaseInfoDetail(DycActivityDO dycActivityDO);

    /**
     * 描述:活动状态更新服务
     *
     * @param reqBO
     * @return int
     */
    void insert(DycActiveBaseInfoSaveReqBO reqBO);

    /**
     * 插入单条数据
     *
     * @param reqBO 参数对象
     * @return int 影响数量
     */
    int insertNew(DycActivityBaseInfo reqBO);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateByNew(DycActivityBaseInfo set,DycActivityBaseInfo where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBO 参数对象
     * @return int 总数量
     */
    int getCheckByNew(DycActivityBaseInfo reqBO);

    /**
     * 根据条件查询单条数据
     *
     * @param reqBO 参数对象
     * @return ActActivityBaseInfoPO 结果对象
     */
    DycActivityBaseInfo getModelByNew(DycActivityBaseInfo reqBO);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBO 参数对象
     * @return List<ActActivityBaseInfoPO> 结果对象
     */
    List<DycActivityBaseInfo> getListNew(DycActivityBaseInfo reqBO);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatchNew(List<DycActivityBaseInfo> list);
}
