package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 描述: 〈活动用户基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:29
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityUserRepository {
    /**
     * 活动已选用户列表分页查询服务
     * @param reqBO
     * @return
     */
    DycSaasActQueryActivityUserPageListRspBO queryActivityUserPageList(DycActivityDO reqBO);
    /**
     * 活动已选用户列表查询服务
     * @param reqBO
     * @return
     */
    List<DycActivityUserInfo> queryActivityUserList(DycActivityDO reqBO);
    /**
     * 活动已选用户列表查询服务
     * @param reqBO
     * @return
     */
    List<DycActivityUserInfo> queryActivityUserNotInPoolList(DycActivityDO reqBO);
    /**
     * 活动用户新增
     * @param reqBO
     * @return
     */
    int addUser(DycActivityDO reqBO);
    /**
     * 描述:活动用户选择（批量）
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO);
    /**
     * 描述:活动用户移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO);
    /**
     * 描述:活跃用户积分修改服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO);

    /**
     * 描述:活动用户积分修改（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO);

    /**
     * 活动用户积分流水查询（分页）服务
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO);

    /**
     * 活动积分扣减/退还服务
     * @param reqBO
     * @return
     */
    int deductOrReturnActivityScores(DycActivityDO reqBO);
    /**
     * 根据活动id删除用户服务
     * @param reqBO
     * @return
     */
    int deleteActivityUser(DycActivityDO reqBO);
    /**
     * 描述:查询活动总积分
     *
     * @param reqBO
     * @return int
     */
    BigDecimal selectCountUserScores(DycActivityDO reqBO);
    /**
     * 描述:查询活动用户总数
     *
     * @param reqBO
     * @return int
     */
    int selectCountUser(DycActivityDO reqBO);

    /**
     * 查询用户参与的活动
     * @param reqBO
     * @return
     */
    List<DycActActivityInfo> qryActInfoByUserId(DycActQryActInfoByUserQryDO reqBO);


    /**
     * 修改活动用户
     *
     * @param info
     */
    void updateActivityUser(DycActivityUserInfo info);

    /**
     * 用户积分信息查询
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActUserScoresBaseInfo> queryUserScoresPageList(DycActUserScoresBaseInfoQueryBO reqBO);


    /**
     * 插入单条数据
     *
     * @param reqBo 参数对象
     * @return int 影响数量
     */
    int insertNew(DycActivityUserInfo  reqBo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateByNew(DycActivityUserInfo  set, DycActivityUserInfo  where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNew(DycActivityUserInfo  reqBo);

    /**
     * 根据条件查询单条数据
     *
     * @param reqBo 参数对象
     * @return ActActivityRelaCommodityPO 结果对象
     */
    DycActivityUserInfo  getModelByNew(DycActivityUserInfo  reqBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<ActActivityRelaCommodityPO> 结果对象
     */
    List<DycActivityUserInfo > getListNew(DycActivityUserInfo  reqBo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatchNew(List<DycActivityUserInfo> list);

    /**
     * 根据条件校验有多少条数据
     *
     * @param reqBo 参数对象
     * @return int 总数量
     */
    int getCheckByNewByCheck(DycActivityUserInfo  reqBo);

    BasePageRspBo<DycActUserScoresBaseInfo> qryActivityUserInfoPageList(DycActUserScoresBaseInfoQueryBO queryBO);

    int selectNotUsedScores(DycActivityDO reqBO);
}
