package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.ActAlreadySyncExternalUserDO;
import com.tydic.dyc.act.model.bo.ActAlreadySyncExternalUserInfo;

import java.util.List;

/**
 * 描述：已同步外部用户池
 *
 * @author: liaoyang
 * @date: 2024-04-15 16:26:44
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActAlreadySyncExternalUserRepository {

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actAlreadySyncExternalUserReqBO
     * @return: ActAlreadySyncExternalUserRspBO
     * @author: liaoyang
     * @date: 2024-04-15 16:26:44
     */
    List<ActAlreadySyncExternalUserInfo> queryActAlreadySyncExternalUserList(ActAlreadySyncExternalUserDO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actAlreadySyncExternalUserReqBO
     * @return: ActAlreadySyncExternalUserRspBO
     * @author: liaoyang
     * @date: 2024-04-15 16:26:44
     */
    int addListActAlreadySyncExternalUser(List<ActAlreadySyncExternalUserDO> reqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actAlreadySyncExternalUserReqBO
     * @return: ActAlreadySyncExternalUserRspBO
     * @author: liaoyang
     * @date: 2024-04-15 16:26:44
     */
    int deleteActAlreadySyncExternalUser(ActAlreadySyncExternalUserDO reqBO);

}

