package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.DycActivityFileInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;

import java.util.List;

/**
 * 描述: 〈附件基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:31
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActFileRepository {
    /**
     * 根据条件查询活动附件信息列表
     * @param reqBO
     * @return
     */
    List<DycActivityFileInfo> queryActivityFileList(DycActivityDO reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: reqBO
     * @return: DycActivityFileInfo
     * @author: zhoulu
     * @date: 2023-12-11 16:44:00
     */
    DycActivityFileInfo saveActivityFileInfo(DycActivityFileInfo reqBO);
    /**
     * 描述:修改信息
     *
     * @throws
     * @param: reqBO
     * @return: DycActivityFileInfo
     * @author: zhoulu
     * @date: 2023-12-11 16:44:00
     */
    DycActivityFileInfo updateActivityFileInfo(DycActivityFileInfo reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: reqBO
     * @return: List<DycActivityFileInfo>
     * @author: zhoulu
     * @date: 2023-12-11 16:44:00
     */
    List<DycActivityFileInfo> addListActivityFileInfo(List<DycActivityFileInfo> reqBO);

    /**
     * 删除结算单对账单
     * @param reqBO
     * @return
     */
    int deleteActivityFileInfo(DycActivityFileInfo reqBO);

    /**
     * 查询单个附件信息
     * @param reqBO
     * @return
     */
    DycActivityFileInfo queryActivityFile(DycActivityFileInfo reqBO);

    /**
     * 描述: 按条件更新（可选择的）
     *
     * @throws
     * @param: po
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    void updateByObjId(DycActivityFileInfo reqBo);
}
