package com.tydic.dyc.act.repository.api;

import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoBO;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoListRspBO;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoReqBO;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoRspBO;

import java.util.List;

/**
 * 描述：
 *
 * @author: liaoyang
 * @date: 2024-04-25 11:01:29
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActOrderConsigneeInfoRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actOrderConsigneeInfoReqBO
     * @return: ActOrderConsigneeInfoRspBO
     * @author: liaoyang
     * @date: 2024-04-25 11:01:29
     */
    ActOrderConsigneeInfoRspBO queryActOrderConsigneeInfoSingle(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actOrderConsigneeInfoReqBO
     * @return: ActOrderConsigneeInfoRspBO
     * @author: liaoyang
     * @date: 2024-04-25 11:01:29
     */
    ActOrderConsigneeInfoListRspBO queryActOrderConsigneeInfoList(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actOrderConsigneeInfoReqBO
     * @return: ActOrderConsigneeInfoRspBO
     * @author: liaoyang
     * @date: 2024-04-25 11:01:29
     */
    RspPage<ActOrderConsigneeInfoBO> queryActOrderConsigneeInfoListPage(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actOrderConsigneeInfoReqBO
     * @return: ActOrderConsigneeInfoRspBO
     * @author: liaoyang
     * @date: 2024-04-25 11:01:29
     */
    ActOrderConsigneeInfoRspBO addActOrderConsigneeInfo(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actOrderConsigneeInfoReqBO
     * @return: ActOrderConsigneeInfoRspBO
     * @author: liaoyang
     * @date: 2024-04-25 11:01:29
     */
    ActOrderConsigneeInfoListRspBO addListActOrderConsigneeInfo(List<ActOrderConsigneeInfoReqBO> actOrderConsigneeInfoReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actOrderConsigneeInfoReqBO
     * @return: ActOrderConsigneeInfoRspBO
     * @author: liaoyang
     * @date: 2024-04-25 11:01:29
     */
    ActOrderConsigneeInfoRspBO updateActOrderConsigneeInfo(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actOrderConsigneeInfoReqBO
     * @return: ActOrderConsigneeInfoRspBO
     * @author: liaoyang
     * @date: 2024-04-25 11:01:29
     */
    ActOrderConsigneeInfoRspBO saveActOrderConsigneeInfo(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actOrderConsigneeInfoReqBO
     * @return: ActOrderConsigneeInfoRspBO
     * @author: liaoyang
     * @date: 2024-04-25 11:01:29
     */
    ActOrderConsigneeInfoRspBO deleteActOrderConsigneeInfo(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO);

}

