package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName DycActOrderInfoRepository
 * @Author 14051
 * @Date 2024/4/2 10:50
 * @Version 1.0
 **/
public interface DycActOrderInfoRepository {
    BasePageRspBo<DycActOrderInfo> qryOrdInfoPageList(DycActOrderQryDO dycActOrderQryDO);

    BasePageRspBo<DycActOrderAfsInfo> qryOrdAfsInfoPageList(DycActOrderAfsQryDO dycActOrderAfsQryDO);

    BigDecimal getTotalScoreByActivityId(Long activityId);

    List<String> qryAlertOrderList(DycActDealAlertQryOrderDO reqBO);

    void updateOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO);

    List<ActAlertOrderInfo> qryExistAlertOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO);

    List<String> qryAlertAfsOrderList(DycActDealAlertQryOrderDO reqBO);

    void updateAfsOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO);

    List<ActAlertAfsOrderInfo> qryExistAlertAfsOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO);

    List<DycActOrderInfo> qryActSum(List<Long> reqBO);

    /**
     * 预警订单列表获取
     * @return
     */
    List<DycActOrderInfo> getWarnIngOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO);

    /**
     * 预警售后单列表获取
     * @param qryDO
     * @return
     */
    List<ActOrderAfterInfo> getOrderAfterWaring(DycActOrderAfsQryDO qryDO);
    String getUnFinishOrderId(DycActOrderQryDO reqBO);

    DycActOrderInfo queryOrderDetail(DycActOrderQryDO qryDO);

    List<ActOrderItemInfoDO> qryOrderItemInfoList(DycActOrderQryDO qryDO);
}
