package com.tydic.dyc.act.repository.api;


import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolListRspBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolReqBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolRspBO;

import java.util.List;

/**
 * 描述：商品池关联商品表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:31
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActRelSkuPoolRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSkuPoolRspBO queryActRelSkuPoolSingle(ActRelSkuPoolReqBO actRelSkuPoolReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSkuPoolListRspBO queryActRelSkuPoolList(ActRelSkuPoolReqBO actRelSkuPoolReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    RspPage<ActRelSkuPoolBO> queryActRelSkuPoolListPage(ActRelSkuPoolReqBO actRelSkuPoolReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSkuPoolRspBO addActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSkuPoolListRspBO addListActRelSkuPool(List<ActRelSkuPoolReqBO> actRelSkuPoolReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSkuPoolRspBO updateActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSkuPoolRspBO saveActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSkuPoolRspBO deleteActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO);

    /**
     * 描述:删除多条信息
     *
     * @throws
     * @param: actRelSkuPoolReqBO
     * @return: ActRelSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSkuPoolRspBO deleteListActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO);

}

