package com.tydic.dyc.act.repository.api;


import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolListRspBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolReqBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolRspBO;

import java.util.List;
import java.util.Map;

/**
 * 描述：商品池关联商品表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:31
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActRelSourcePoolRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSourcePoolRspBO queryActRelSourcePoolSingle(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSourcePoolListRspBO queryActRelSourcePoolList(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    RspPage<ActRelSourcePoolBO> queryActRelSourcePoolListPage(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSourcePoolRspBO addActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSourcePoolListRspBO addListActRelSourcePool(List<ActRelSourcePoolReqBO> actRelSourcePoolReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSourcePoolRspBO updateActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSourcePoolRspBO saveActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSourcePoolRspBO deleteActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

    /**
     * 描述:删除多条信息
     *
     * @throws
     * @param: actRelSourcePoolReqBO
     * @return: ActRelSourcePoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:31
     */
    ActRelSourcePoolRspBO deleteListActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

    Map<Long,Integer> getSkuNumBySource(ActRelSourcePoolReqBO actRelSourcePoolReqBO);

}

