package com.tydic.dyc.act.repository.api;


import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActSkuDetailBO;
import com.tydic.dyc.act.model.bo.ActSkuDetailListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuDetailReqBO;
import com.tydic.dyc.act.model.bo.ActSkuDetailRspBO;

import java.util.List;

/**
 * 描述：商品描述表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActSkuDetailRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actSkuDetailReqBO
     * @return: ActSkuDetailRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuDetailRspBO queryActSkuDetailSingle(ActSkuDetailReqBO actSkuDetailReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actSkuDetailReqBO
     * @return: ActSkuDetailRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuDetailListRspBO queryActSkuDetailList(ActSkuDetailReqBO actSkuDetailReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actSkuDetailReqBO
     * @return: ActSkuDetailRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    RspPage<ActSkuDetailBO> queryActSkuDetailListPage(ActSkuDetailReqBO actSkuDetailReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actSkuDetailReqBO
     * @return: ActSkuDetailRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuDetailRspBO addActSkuDetail(ActSkuDetailReqBO actSkuDetailReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actSkuDetailReqBO
     * @return: ActSkuDetailRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuDetailListRspBO addListActSkuDetail(List<ActSkuDetailReqBO> actSkuDetailReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actSkuDetailReqBO
     * @return: ActSkuDetailRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuDetailRspBO updateActSkuDetail(ActSkuDetailReqBO actSkuDetailReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actSkuDetailReqBO
     * @return: ActSkuDetailRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuDetailRspBO saveActSkuDetail(ActSkuDetailReqBO actSkuDetailReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actSkuDetailReqBO
     * @return: ActSkuDetailRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuDetailRspBO deleteActSkuDetail(ActSkuDetailReqBO actSkuDetailReqBO);

}

