package com.tydic.dyc.act.repository.api;


import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListRspBO;

import java.util.List;

/**
 * 描述：商品类目表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActSkuGuideRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actSkuGuideReqBO
     * @return: ActSkuGuideRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuGuideRspBO queryActSkuGuideSingle(ActSkuGuideReqBO actSkuGuideReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actSkuGuideReqBO
     * @return: ActSkuGuideRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuGuideListRspBO queryActSkuGuideList(ActSkuGuideReqBO actSkuGuideReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actSkuGuideReqBO
     * @return: ActSkuGuideRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    RspPage<ActSkuGuideBO> queryActSkuGuideListPage(ActSkuGuideReqBO actSkuGuideReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actSkuGuideReqBO
     * @return: ActSkuGuideRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuGuideRspBO addActSkuGuide(ActSkuGuideReqBO actSkuGuideReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actSkuGuideReqBO
     * @return: ActSkuGuideRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuGuideListRspBO addListActSkuGuide(List<ActSkuGuideReqBO> actSkuGuideReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actSkuGuideReqBO
     * @return: ActSkuGuideRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuGuideRspBO updateActSkuGuide(ActSkuGuideReqBO actSkuGuideReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actSkuGuideReqBO
     * @return: ActSkuGuideRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuGuideRspBO saveActSkuGuide(ActSkuGuideReqBO actSkuGuideReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actSkuGuideReqBO
     * @return: ActSkuGuideRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuGuideRspBO deleteActSkuGuide(ActSkuGuideReqBO actSkuGuideReqBO);

    DycActGuideDO qryGuideTree(DycActGuideQryDO reqBO);

    ActSkuGuideListRspBO getCatalogBOByCatalogIds(ActSkuGuideReqBO actSkuGuideReqBO);

    DycActQueryCatalogListRspBO getCatalogNotChildSearch(DycActQueryCatalogListReqBO reqBO);

    ActSkuGuideCheckDelRspBO checkDelCatalog(ActSkuGuideCheckDelReqBO reqBO);

    ActSkuSortGuideRspBO changeCatalogOrder(ActSkuSortGuideReqBO reqBO);

    ActSkuSortGuideRspBO importGuide(List<DycActQueryCatalogListBO> guideBOList);
}

