package com.tydic.dyc.act.repository.api;

import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActSkuPicBO;
import com.tydic.dyc.act.model.bo.ActSkuPicListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPicReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPicRspBO;

import java.util.List;

/**
 * 描述：商品图片表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActSkuPicRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actSkuPicReqBO
     * @return: ActSkuPicRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPicRspBO queryActSkuPicSingle(ActSkuPicReqBO actSkuPicReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actSkuPicReqBO
     * @return: ActSkuPicRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPicListRspBO queryActSkuPicList(ActSkuPicReqBO actSkuPicReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actSkuPicReqBO
     * @return: ActSkuPicRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    RspPage<ActSkuPicBO> queryActSkuPicListPage(ActSkuPicReqBO actSkuPicReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actSkuPicReqBO
     * @return: ActSkuPicRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPicRspBO addActSkuPic(ActSkuPicReqBO actSkuPicReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actSkuPicReqBO
     * @return: ActSkuPicRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPicListRspBO addListActSkuPic(List<ActSkuPicReqBO> actSkuPicReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actSkuPicReqBO
     * @return: ActSkuPicRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPicRspBO updateActSkuPic(ActSkuPicReqBO actSkuPicReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actSkuPicReqBO
     * @return: ActSkuPicRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPicRspBO saveActSkuPic(ActSkuPicReqBO actSkuPicReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actSkuPicReqBO
     * @return: ActSkuPicRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPicRspBO deleteActSkuPic(ActSkuPicReqBO actSkuPicReqBO);

}

