package com.tydic.dyc.act.repository.api;


import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActSkuPoolBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolRspBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRspBO;

import java.util.List;

/**
 * 描述：商品池表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActSkuPoolRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actSkuPoolReqBO
     * @return: ActSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    DycActQuerySkuPoolRspBO queryActSkuPoolSingle(DycActQuerySkuPoolReqBO actSkuPoolReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actSkuPoolReqBO
     * @return: ActSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPoolListRspBO queryActSkuPoolList(ActSkuPoolReqBO actSkuPoolReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actSkuPoolReqBO
     * @return: ActSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    RspPage<ActSkuPoolBO> queryActSkuPoolListPage(ActSkuPoolReqBO actSkuPoolReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actSkuPoolReqBO
     * @return: ActSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPoolRspBO addActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actSkuPoolReqBO
     * @return: ActSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPoolListRspBO addListActSkuPool(List<ActSkuPoolReqBO> actSkuPoolReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actSkuPoolReqBO
     * @return: ActSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPoolRspBO updateActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actSkuPoolReqBO
     * @return: ActSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPoolRspBO saveActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actSkuPoolReqBO
     * @return: ActSkuPoolRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPoolRspBO deleteActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO);

    RspPage<ActSkuPoolBO> querySkuPoolPageList(ActSkuPoolReqBO actSkuPoolReqBO);
}

