package com.tydic.dyc.act.repository.api;


import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogRspBO;

import java.util.List;

/**
 * 描述：单品价格历史表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActSkuPriceLogRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actSkuPriceLogReqBO
     * @return: ActSkuPriceLogRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPriceLogRspBO queryActSkuPriceLogSingle(ActSkuPriceLogReqBO actSkuPriceLogReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actSkuPriceLogReqBO
     * @return: ActSkuPriceLogRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPriceLogListRspBO queryActSkuPriceLogList(ActSkuPriceLogReqBO actSkuPriceLogReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actSkuPriceLogReqBO
     * @return: ActSkuPriceLogRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    RspPage<ActSkuPriceLogBO> queryActSkuPriceLogListPage(ActSkuPriceLogReqBO actSkuPriceLogReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actSkuPriceLogReqBO
     * @return: ActSkuPriceLogRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPriceLogRspBO addActSkuPriceLog(ActSkuPriceLogReqBO actSkuPriceLogReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actSkuPriceLogReqBO
     * @return: ActSkuPriceLogRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPriceLogListRspBO addListActSkuPriceLog(List<ActSkuPriceLogReqBO> actSkuPriceLogReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actSkuPriceLogReqBO
     * @return: ActSkuPriceLogRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPriceLogRspBO updateActSkuPriceLog(ActSkuPriceLogReqBO actSkuPriceLogReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actSkuPriceLogReqBO
     * @return: ActSkuPriceLogRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPriceLogRspBO saveActSkuPriceLog(ActSkuPriceLogReqBO actSkuPriceLogReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actSkuPriceLogReqBO
     * @return: ActSkuPriceLogRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuPriceLogRspBO deleteActSkuPriceLog(ActSkuPriceLogReqBO actSkuPriceLogReqBO);

}

