package com.tydic.dyc.act.repository.api;


import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActSkuSpecBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecReqBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecRspBO;

import java.util.List;

/**
 * 描述：商品属性表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActSkuSpecRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actSkuSpecReqBO
     * @return: ActSkuSpecRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuSpecRspBO queryActSkuSpecSingle(ActSkuSpecReqBO actSkuSpecReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actSkuSpecReqBO
     * @return: ActSkuSpecRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuSpecListRspBO queryActSkuSpecList(ActSkuSpecReqBO actSkuSpecReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actSkuSpecReqBO
     * @return: ActSkuSpecRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    RspPage<ActSkuSpecBO> queryActSkuSpecListPage(ActSkuSpecReqBO actSkuSpecReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actSkuSpecReqBO
     * @return: ActSkuSpecRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuSpecRspBO addActSkuSpec(ActSkuSpecReqBO actSkuSpecReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actSkuSpecReqBO
     * @return: ActSkuSpecRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuSpecListRspBO addListActSkuSpec(List<ActSkuSpecReqBO> actSkuSpecReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actSkuSpecReqBO
     * @return: ActSkuSpecRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuSpecRspBO updateActSkuSpec(ActSkuSpecReqBO actSkuSpecReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actSkuSpecReqBO
     * @return: ActSkuSpecRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuSpecRspBO saveActSkuSpec(ActSkuSpecReqBO actSkuSpecReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actSkuSpecReqBO
     * @return: ActSkuSpecRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuSpecRspBO deleteActSkuSpec(ActSkuSpecReqBO actSkuSpecReqBO);

}

