package com.tydic.dyc.act.repository.api;


import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.model.bo.ActSkuVendorBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorReqBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorRspBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolNotRelVendorPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolNotRelVendorPageListRspBO;

import java.util.List;

/**
 * 描述：商品供应商表
 *
 * @author: zhouhaifeng
 * @date: 2024-04-02 14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActSkuVendorRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: actSkuVendorReqBO
     * @return: ActSkuVendorRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuVendorRspBO queryActSkuVendorSingle(ActSkuVendorReqBO actSkuVendorReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: actSkuVendorReqBO
     * @return: ActSkuVendorRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuVendorListRspBO queryActSkuVendorList(ActSkuVendorReqBO actSkuVendorReqBO);

    /**
     * 描述:查询信息列表（分页）
     *
     * @throws
     * @param: actSkuVendorReqBO
     * @return: ActSkuVendorRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    RspPage<ActSkuVendorBO> queryActSkuVendorListPage(ActSkuVendorReqBO actSkuVendorReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: actSkuVendorReqBO
     * @return: ActSkuVendorRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuVendorRspBO addActSkuVendor(ActSkuVendorReqBO actSkuVendorReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: actSkuVendorReqBO
     * @return: ActSkuVendorRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuVendorListRspBO addListActSkuVendor(List<ActSkuVendorReqBO> actSkuVendorReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: actSkuVendorReqBO
     * @return: ActSkuVendorRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuVendorRspBO updateActSkuVendor(ActSkuVendorReqBO actSkuVendorReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: actSkuVendorReqBO
     * @return: ActSkuVendorRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuVendorRspBO saveActSkuVendor(ActSkuVendorReqBO actSkuVendorReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: actSkuVendorReqBO
     * @return: ActSkuVendorRspBO
     * @author: zhouhaifeng
     * @date: 2024-04-02 14:48:30
     */
    ActSkuVendorRspBO deleteActSkuVendor(ActSkuVendorReqBO actSkuVendorReqBO);

    DycActQuerySkuPoolNotRelVendorPageListRspBO querySkuPoolNotRelVendorPageList(DycActQuerySkuPoolNotRelVendorPageListReqBO reqBO);

}

