package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.DycActivityFlowTaskInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;

import java.util.List;

/**
 * 描述：流程任务表
 *
 * @author: zhoulu
 * @date: 2023-12-19 15:49:50
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActivityFlowTaskRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: activityFlowTaskReqBO
     * @return: ActivityFlowTaskRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    DycActivityFlowTaskInfo queryActivityFlowTaskSingle(DycProcessDO reqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: activityFlowTaskReqBO
     * @return: ActivityFlowTaskRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    List<DycActivityFlowTaskInfo> queryActivityFlowTaskList(DycProcessDO reqBO);


    /**
     * 描述:新增信息
     *
     * @throws
     * @param: activityFlowTaskReqBO
     * @return: ActivityFlowTaskRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    int addActivityFlowTask(DycProcessDO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: activityFlowTaskReqBO
     * @return: ActivityFlowTaskRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    int addListActivityFlowTask(DycProcessDO reqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: activityFlowTaskReqBO
     * @return: ActivityFlowTaskRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    int updateActivityFlowTask(DycProcessDO reqBO);


    /**
     * 描述:删除信息
     *
     * @throws
     * @param: activityFlowTaskReqBO
     * @return: ActivityFlowTaskRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    int deleteActivityFlowTask(DycProcessDO reqBO);

    /**
     * 描述:针对于会签的状态更新
     *
     * @param reqBO
     * @return int
     */
    int updateBatchTaskState(DycProcessDO reqBO);
}

