package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.model.bo.DycActLaborUnionInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 标题：DycActlaborRepository
 * 说明：
 * 时间： 2024-03-26 15:47
 * 作者 @author LY
 */
public interface DycActlaborRepository {

    /**
     * 描述:工会新增服务
     *
     * @param reqBO
     * @return int
     */
    Long addActLaborUnionInfo(DycActIaborDO reqBO);
    /**
     * 描述:工会-机构依赖新增服务
     *
     * @param reqBO
     * @return int
     */
    int addListActLaborUnionRelaOrg(DycActIaborDO reqBO);
    /**
     * 描述:工会修改服务
     *
     * @param reqBO
     * @return int
     */
    int updateActLaborUnionInfo(DycActIaborDO reqBO);
    /**
     * 描述:删除机构与工会关系服务
     *
     * @param reqBO
     * @return int
     */
    int deleteListActLaborUnionRelaOrg(DycActIaborDO reqBO);
    /**
     * 描述:删除工会服务
     *
     * @param reqBO
     * @return int
     */
    int deleteActLaborUnionInfo(DycActIaborDO reqBO);
    /**
     * 描述:工会列表查询（分页）服务
     *
     * @param reqBO
     * @return int
     */
    BasePageRspBo<DycActLaborUnionInfo> queryLaborUnionPageList(DycActIaborDO reqBO);
    /**
     * 描述:工会详情查询
     *
     * @param reqBO
     * @return int
     */
    DycActLaborUnionInfo queryActLaborUnionInfo(DycActIaborDO reqBO);
    /**
     * 描述:工会对应机构详情查询
     *
     * @param reqBO
     * @return int
     */
    DycActLaborUnionInfo queryListActLaborUnionRelaOrg(DycActIaborDO reqBO);
    /**
     * 描述:机构所属工会下拉框查询服务
     *
     * @param reqBO
     * @return int
     */
    List<DycActLaborUnionInfo> queryOrgBelongLaborUnion(DycActIaborDO reqBO);
}
