package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.ActActivityWarningModel;
import com.tydic.dyc.act.model.bo.ActActivityWarning;
import com.tydic.dyc.act.service.api.DycActActivityAddWarningService;
import com.tydic.dyc.act.service.bo.DycActActivityAddWarningReqBO;
import com.tydic.dyc.act.service.bo.DycActActivityAddWarningRspBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 DycActActivityAddWarningServiceImpl
 * 说明 新增预警记录
 * 时间 2024/4/23 16:49
 *
 * @author 唐富强
 */
@HTServiceImpl
public class DycActActivityAddWarningServiceImpl implements DycActActivityAddWarningService {

    @Autowired
    private ActActivityWarningModel actActivityWarningModel;
    @Override
    public DycActActivityAddWarningRspBO addWarning(DycActActivityAddWarningReqBO reqBO) {
        List<ActActivityWarning> actActivityWarnings = ActRu.jsl(reqBO.getList(), ActActivityWarning.class);
        actActivityWarningModel.allInsert(actActivityWarnings);
        return new DycActActivityAddWarningRspBO();
    }
}
