package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.service.api.DycActActivityCodeService;
import com.tydic.dyc.act.service.bo.DycActCodegenerationBusiReqBO;
import com.tydic.dyc.act.service.bo.DycActCodegenerationBusiRspBO;

import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：DycActActivityCodeServiceImpl
 * 说明：
 * 时间： 2024-04-08 14:43
 * 作者 @author LY
 */
@Slf4j
@HTServiceImpl
public class DycActActivityCodeServiceImpl implements DycActActivityCodeService {

    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;

    @Override
    public DycActCodegenerationBusiRspBO dealCodegeneration(DycActCodegenerationBusiReqBO reqBO) {

        CfcEncodedSerialGetServiceReqBO CfcEncodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        CfcEncodedSerialGetServiceReqBO.setEncodedRuleCode(reqBO.getType());
        CfcEncodedSerialGetServiceReqBO.setCenter("ACT");
        CfcEncodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceReqBO.setNum(reqBO.getCount());
        CfcEncodedSerialGetServiceRspBO encodedSerial = new CfcEncodedSerialGetServiceRspBO();
        if (reqBO.getUpperCode() != null && !"".equals(reqBO.getUpperCode())) {
            // 装入上级编码code
            List<String> replaceValue = new ArrayList<>();
            replaceValue.add(reqBO.getUpperCode());
            CfcEncodedSerialGetServiceReqBO.setReplaceValue(replaceValue);
        }
        try {
            encodedSerial = cfcEncodedSerialGetService.getEncodedSerial(CfcEncodedSerialGetServiceReqBO);
        } catch (Exception e) {
            throw new ZTBusinessException("调用编码生成中心失败:" + e.getMessage());
        }
        List<String> codeList = new ArrayList<>(encodedSerial.getSerialNoList());

        DycActCodegenerationBusiRspBO rspBO = new DycActCodegenerationBusiRspBO();
        rspBO.setCodeList(codeList);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
