package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.ActOrderAfterInfo;
import com.tydic.dyc.act.model.bo.DycActOrderAfsQryDO;
import com.tydic.dyc.act.service.api.DycActActivityGetWarnIngOrderAfterListService;
import com.tydic.dyc.act.service.bo.ActOrderAfterInfoBO;
import com.tydic.dyc.act.service.bo.DycActActivityGetWarnIngOrderAfterListReqBO;
import com.tydic.dyc.act.service.bo.DycActActivityGetWarnIngOrderAfterListRspBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 DycActActivityGetWarnIngOrderAfterListServiceImpl
 * 说明 获取预警售后单
 * 时间 2024/4/24 11:11
 *
 * @author 唐富强
 */
@HTServiceImpl
public class DycActActivityGetWarnIngOrderAfterListServiceImpl implements DycActActivityGetWarnIngOrderAfterListService {

    @Autowired
    private DycActOrderModel dycActOrderModel;
    @Override
    public DycActActivityGetWarnIngOrderAfterListRspBO getWarningOrderAfter(DycActActivityGetWarnIngOrderAfterListReqBO reqBO) {
        DycActOrderAfsQryDO dycActOrderAfsQryDO = ActRu.js(reqBO, DycActOrderAfsQryDO.class);
        List<ActOrderAfterInfo> orderAfterWaring = dycActOrderModel.getOrderAfterWaring(dycActOrderAfsQryDO);
        DycActActivityGetWarnIngOrderAfterListRspBO rspBO = new DycActActivityGetWarnIngOrderAfterListRspBO();
        rspBO.setList(ActRu.jsl(orderAfterWaring, ActOrderAfterInfoBO.class));
        return rspBO;
    }
}
