package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.DycActDealAlertQryOrderDO;
import com.tydic.dyc.act.model.bo.DycActOrderInfo;
import com.tydic.dyc.act.service.api.DycActActivityGetWarnIngOrderListService;
import com.tydic.dyc.act.service.bo.DycActActivityGetWarnIngOrderListReqBO;
import com.tydic.dyc.act.service.bo.DycActActivityGetWarnIngOrderListRspBO;
import com.tydic.dyc.act.service.bo.DycActOrderInfoBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 DycActActivityGetWarnIngOrderListServiceImpl
 * 说明 预警订单列表获取
 * 时间 2024/4/23 16:41
 *
 * @author 唐富强
 */
@HTServiceImpl
public class DycActActivityGetWarnIngOrderListServiceImpl implements DycActActivityGetWarnIngOrderListService {

    @Autowired
    private DycActOrderModel dycActOrderModel;
    @Override
    public DycActActivityGetWarnIngOrderListRspBO getWarnIngOrderList(DycActActivityGetWarnIngOrderListReqBO reqBO) {

        DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO = ActRu.js(reqBO, DycActDealAlertQryOrderDO.class);
        List<DycActOrderInfo> warnIngOrderList = dycActOrderModel.getWarnIngOrderList(dycActDealAlertQryOrderDO);
        DycActActivityGetWarnIngOrderListRspBO rspBO = ActRu.success(DycActActivityGetWarnIngOrderListRspBO.class);
        rspBO.setList(ActRu.jsl(warnIngOrderList, DycActOrderInfoBO.class));
        return rspBO;
    }
}
