package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActActivityInfo;
import com.tydic.dyc.act.model.bo.DycActQryActInfoByUserQryDO;
import com.tydic.dyc.act.service.api.DycActActivityQryActivityByUserIdService;
import com.tydic.dyc.act.service.bo.DycActActivityInfoBO;
import com.tydic.dyc.act.service.bo.DycActActivityQryActivityByUserIdReqBO;
import com.tydic.dyc.act.service.bo.DycActActivityQryActivityByUserIdRspBO;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @ClassName DycActActivityQryActivityByUserIdServiceImpl
 * @Author 14051
 * @Date 2024/4/10 14:28
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActActivityQryActivityByUserIdServiceImpl implements DycActActivityQryActivityByUserIdService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActActivityQryActivityByUserIdRspBO qryActInfoByUserId(DycActActivityQryActivityByUserIdReqBO reqBO) {
        if (reqBO.getUserId() == null){
            throw new ZTBusinessException("查询活动列表用户ID不能为空");
        }
        DycActActivityQryActivityByUserIdRspBO rspBO = new DycActActivityQryActivityByUserIdRspBO();
        DycActQryActInfoByUserQryDO dycActQryActInfoByUserQryDO = new DycActQryActInfoByUserQryDO();
        dycActQryActInfoByUserQryDO.setUserId(reqBO.getUserId());
        List<DycActActivityInfo> actActivityInfos = dycActActivityModel.qryActInfoByUserId(dycActQryActInfoByUserQryDO);
        if (!CollectionUtils.isEmpty(actActivityInfos)){
            rspBO.setActivityList(JUtil.jsl(actActivityInfos, DycActActivityInfoBO.class));
        }
        return rspBO;
    }
}
