package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordDO;
import com.tydic.dyc.act.service.api.DycActActivitySyncExternalRecordService;
import com.tydic.dyc.act.service.bo.DycActBatchAddActivitySyncExternalRecordReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchAddActivitySyncExternalRecordRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActActivitySyncExternalRecordServiceImpl
 * 说明：
 * 时间： 2024-04-12 10:08
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActActivitySyncExternalRecordServiceImpl implements DycActActivitySyncExternalRecordService {

    @Autowired
    private DycActActivityModel dycActActivityModel;


    @Override
    public DycActBatchAddActivitySyncExternalRecordRspBO addBatchActivitySyncExternalRecord(DycActBatchAddActivitySyncExternalRecordReqBO reqBO) {

        List<ActActivitySyncExternalRecordDO> recordDOS = JSON.parseArray(JSON.toJSONString(reqBO.getList()), ActActivitySyncExternalRecordDO.class);
        dycActActivityModel.addBatchActivitySyncExternalRecord(recordDOS);
        DycActBatchAddActivitySyncExternalRecordRspBO rspBO = new DycActBatchAddActivitySyncExternalRecordRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
