package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActIaborModel;
import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.service.api.DycActAddLaborUnionService;
import com.tydic.dyc.act.service.bo.DycActAddLaborUnionReqBO;
import com.tydic.dyc.act.service.bo.DycActAddLaborUnionRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/**
 * 标题：DycActAddLaborUnionServiceImpl
 * 说明：
 * 时间： 2024-03-26 16:34
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActAddLaborUnionServiceImpl implements DycActAddLaborUnionService {

    @Autowired
    private DycActIaborModel dycActIaborModel;


    @Override
    public DycActAddLaborUnionRspBO addLaborUnion(DycActAddLaborUnionReqBO reqBO) {
        checkParam(reqBO);
        DycActIaborDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActIaborDO.class);
        dycActivityDO.setCreateUserId(reqBO.getUserId());
        dycActivityDO.setCreateUserName(reqBO.getName());
        dycActIaborModel.addLaborUnion(dycActivityDO);
        DycActAddLaborUnionRspBO rspBO = new DycActAddLaborUnionRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    public void checkParam(DycActAddLaborUnionReqBO reqBO){
        if(ObjectUtils.isEmpty(reqBO)){
            throw new ZTBusinessException("参数为空！");
        }
        if(!StringUtils.hasText(reqBO.getLaborUnionName())){
            throw new ZTBusinessException("工会名称为空！");
        }
        if(CollectionUtils.isEmpty(reqBO.getRelaOrgList())){
            throw new ZTBusinessException("关联机构列表为空！");
        }
    }
}
